package com.mini.framework.util.page;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 分段用的bean
 * 一般查数据包含，起始点，长度限制，还爆开包括需不需要求总数。
 * @author jayheo
 *
 */
public class Section {
	private Integer offset = 0;
	private Integer limit;
	/**
	 * 分段查询的时候指定已知count，对于翻页操作的时候完全不需要多次查总数。
	 */
	private Integer count;
	public Integer getOffset() {
		return offset;
	}
	public void setOffset(int offset) {
		this.offset = offset;
	}
	public Integer getLimit() {
		return limit;
	}
	public void setLimit(int limit) {
		this.limit = limit;
	}
	
	public Section() {
		super();
	}
	
	public Integer getCount() {
		return count;
	}
	public void setCount(Integer count) {
		this.count = count;
	}
	public Section(int offset, int limit,int count) {
		this(offset, limit);
		this.count = count;
	}
	
	public Section(int offset, int limit) {
		super();
		this.offset = offset;
		this.limit = limit;
	}
	
	/**
	 * 判断是不是需要count
	 * @return
	 */
	public boolean requireCount(){
		//如果传了总数，且总数还大于目前查的值一点点，这个时候就没有必要算总数了
		boolean requireCount = getCount()==null
				|| getCount() < (getOffset() + getLimit())+ getLimit();
		return requireCount;
	}
	
	/**
	 * 需要的参数完整
	 * @return
	 */
	public boolean requireParamsComplete(){
		return getLimit()!=null && getOffset()!=null && getLimit()>=0 && getOffset()>=0;
	}

	/**
	 * 把当前的实体
	 * 移动一下位置
	 * 比如  10-20变成 50-60
	 * */
	public Section shiftOffset(int increment){
		offset+=increment;
		return this;
	}

	/**
	 * 使用新的副本
	 * 移动一下位置
	 * 比如  10-20变成 50-60
	 * */
	public Section shiftOffsetCopy(int increment){
		return copy().shiftOffset(increment);
	}


	/**
	 * 拷贝一个副本
	 * */
	public Section copy(){
		//TODO 要换成clone的方式
		Section instance = new Section(offset, limit);
		instance.count = this.count;
		return instance;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
