package com.mini.framework.util.qrcode;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;

public class UrlTypeGuessUtil {

	
	/**
	 * 猜测url是不是指定的类开，如果猜中了返回对应的类型
	 * @param content
	 * @param guesses
	 * @return
	 */
	public static GuessType guess(String content,GuessType... guesses){
		AssertUtil.assertMethodRequire(content, "content");
		content = content.toLowerCase();
		for (GuessType type : guesses) {
			String regex = type.getRegex();
			String match = RegexUtil.getMatch(regex, content);
			if(match!=null){
				return type;
			}
		}
		return null;
	}
	
}
