package com.mini.framework.util.report.statistics.ranking;

import com.mini.framework.util.report.statistics.protocol.KeyStringValueStorage;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.ranking.bean.RankingElementSummationAmount;
import com.mini.framework.util.report.statistics.ranking.bean.StatisticsRankingTable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 使用字符串键值储存的 排名特征
 * @param <P>
 */
public interface StringStoreRankingDimensionFeature
        <P extends StatisticsSerializeParams,A extends RankingElementSummationAmount<A>> extends RankingDimensionFeature<P,A>, KeyStringValueStorage {

    /**
     * 保存排行映
     * @param rankingKey 排行榜的key
     * @param ranking 排行榜
     */
    @Override
    default void saveRankingTableToCache(String rankingKey, StatisticsRankingTable<A> ranking){
        String rankingString = ranking.serialize(utilFullyEmptyElement());
        coverSaveStringCache(rankingKey,rankingString);
    }

    @Override
    default Optional<StatisticsRankingTable<A>> queryCacheRankingTable(String rankingKey, Optional<Integer> headOptional){
        return queryStringCacheByKey(rankingKey)
                .map(string-> stringMapperRankingItemScoreList(string,headOptional));
    }

    /**
     * 把字符串变成排行榜
     * @param string
     * @param headOptional
     * @return
     */
    default StatisticsRankingTable<A> stringMapperRankingItemScoreList(String string, Optional<Integer> headOptional){
        StatisticsRankingTable<A> ranking = StatisticsRankingTable.deserialize(string, utilFullyEmptyElement());
        return ranking.retainLimitHead(headOptional);
    }


    @Override
    default Map<String, StatisticsRankingTable<A>> queryBatchCacheRankingTable(Map<String, Optional<Integer>> keyHeadOptionalMapper){
        Map<String, StatisticsRankingTable<A>> mapper = new HashMap<>();
        Map<String, String> keyStringMapper = queryBatchStringCacheByKeys(keyHeadOptionalMapper.keySet());
        keyHeadOptionalMapper.forEach((rankingKey,headOptional)->{
            Optional<String> stringCacheOptional = Optional.ofNullable(keyStringMapper.get(rankingKey));
            stringCacheOptional.ifPresent(stringCache->{
                mapper.put(stringCache,stringMapperRankingItemScoreList(stringCache,headOptional));
            });
        });
        return mapper;
    }

    @Override
    default StatisticsRankingTable<A> accumulateRankingTableToCache(String rankingKey, StatisticsRankingTable<A> incrementRanking, boolean coverOrigin){
        StatisticsRankingTable<A> originRanking = queryCacheRankingTable(rankingKey, Optional.empty()).orElse(StatisticsRankingTable.createEmpty());
        StatisticsRankingTable<A> allRinking = StatisticsRankingTable.accumulateRankings(this::createEmptyElement,originRanking, incrementRanking);
        if(coverOrigin){
            coverSaveStringCache(rankingKey,allRinking.serialize(utilFullyEmptyElement()));
        }
        return allRinking;
    }
}
