package com.mini.framework.util.schedule;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 心跳计算器
 * @author jayheo
 */
public class HeartBeatCounter {
	/**
	 * 延迟
	 */
	private int delay;
	/**
	 * 间隔
	 */
	private int rate;
	
	/**
	 * 初始化标记，防止多次初始化
	 */
	private boolean init;
	
	
	public HeartBeatCounter(int delay, int rate) {
		super();
		this.init(rate, delay);
	}
	public int getDelay() {
		return delay;
	}
	public int getRate() {
		return rate;
	}
	public void init(int rate,int delay){
		AssertUtil.assertNotFatal(!init, "心跳计数器已被初始化");
		AssertUtil.assertSupport(rate>0&&delay>=0, "初始配置参数错误");
		this.rate = rate;
		this.delay = delay;
		this.init = true;
	}
	
	public boolean nextHeartbeat(int currTimePoint) {
		boolean match =currTimePoint - delay>=0 && ((currTimePoint - delay) % rate == 0);
		return match;
	}
	
	
}
