package com.mini.framework.util.sql.view.bean;

import com.github.pagehelper.Page;
import com.mini.framework.util.sql.view.able.ObjectValueReader;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 表值
 * @author jayheo
 */
public class TableValue extends SqlViewBean {

    private TableHead head;

    private List<RowValue> rows;

    /**
     * 行数
     */
    private Integer count;


    //TODO 添加分页结果


    public static TableValue create(List<ColumnDefine> defines){
        TableValue instance = new TableValue();
        instance.head = TableHead.create(defines);
        instance.rows = new ArrayList<>();
        return instance;
    }

    
    public TableValue addRow(ObjectValueReader reader){
        RowValue row = RowValue.fromReader(reader, head.getColumns());
        rows.add(row);
        return this;
    }

    public TableValue fillFromPage(Optional<Page<?>> pageOptional) {
        pageOptional.ifPresent(page->{
            long pageCount = page.getTotal();
            if(pageCount<0){
            }else{
                count = (int)pageCount;
            }
        });
        return this;
    }


    public TableHead getHead() {
        return head;
    }

    public TableValue setHead(TableHead head) {
        this.head = head;
        return this;
    }

    public List<RowValue> getRows() {
        return rows;
    }

    public TableValue setRows(List<RowValue> rows) {
        this.rows = rows;
        return this;
    }

    public Integer getCount() {
        return count;
    }

    public TableValue setCount(Integer count) {
        this.count = count;
        return this;
    }

}
