package com.mini.framework.util.status;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.relation.Cascadable;
import com.mini.framework.util.relation.Cascader;
import com.mini.framework.util.relation.CollUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author jayheo
 */
public class CoreStatus extends StatusCode implements Cascadable<CoreStatus> {

    private List<CoreStatus> subStatuses;

    public List<CoreStatus> getSubStatuses() {
        return subStatuses;
    }

    public void setSubStatuses(List<CoreStatus> subStatuses) {
        this.subStatuses = subStatuses;
    }

    private List<CoreStatus> sureHaveSubs(){
        if(subStatuses==null){
            subStatuses = new ArrayList<>();
        }
        return subStatuses;
    }

    private String stringRealCode(){
        return Optional.ofNullable(getRealCode()).map(String::valueOf)
                .orElseThrow(()->new ServerException("getRealCode返回空出错了"));
    }


    /**
     * 从另外的code生成。
     * */
    public static CoreStatus fromCode(StatusCode code){
        CoreStatus status = new CoreStatus();
        code.copyTo(status);
        return status;
    }

    public static List<CoreStatus> showAllStatusTreeLayout(){
        List<StatusCode> list = Status.showStatuses();
        return CollUtil.tranCascadeTree(list.stream().map(CoreStatus::fromCode).collect(Collectors.toList()));
    }


    @Override
    public String showSuperNodeKey() {
        //TODO 对于没有父级的要怎么处理呢
        return String.valueOf(countFatherCode());
    }

    @Override
    public String showNodeKey() {
        return stringRealCode();
    }

    @Override
    public void addSonNode(CoreStatus node) {
        sureHaveSubs().add(node);
    }

    @Override
    public List<CoreStatus> showSonNodes() {
        return sureHaveSubs();
    }
}
