package com.mini.framework.util.string;

import java.util.Date;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.util.date.DateUtil;

/**
 * 字符串转换显示
 * @author jayheo
 *
 */
public enum StringTransShowType {
	
	/**
	 * long型日期转成秒级字符串
	 */
	longDateToSecondsString,
	
	/**
	 * 什么都不做
	 */
	noHandle
	
	;
	
	public Optional<String> transShow(String input){
		if(input!=null){
			switch(this){
			case longDateToSecondsString:
				Date date = new Date(Long.parseLong(input));
				return Optional.of(DateUtil.toSecondsString(date));
				case noHandle:
					return Optional.of(input);
				default:
					throw new UnsupportedException("暂时不支持字符转换显示:%s",this);
			}
			
		}else{
			return Optional.empty();
		}
	}
}
