/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.alert;

import com.mini.framework.util.aspect.AspectBeanUtil;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.log.trace.MethodTracePointer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;

public class AopLogUtil {
    @Autowired
    private MethodTracePointer methodTracePointer;
    private Logger logger = LogManager.getLogger(AopLogUtil.class);

    @Pointcut(value="@annotation(org.apache.ibatis.annotations.DeleteProvider) || @annotation(org.apache.ibatis.annotations.UpdateProvider) || @annotation(org.apache.ibatis.annotations.InsertProvider) || @annotation(org.apache.ibatis.annotations.Delete) || @annotation(org.apache.ibatis.annotations.Update) || @annotation(org.apache.ibatis.annotations.Insert)")
    public void dbWritePointcut() {
    }

    @AfterReturning(pointcut="dbWritePointcut()", returning="result")
    public void dbWrite(JoinPoint joinPoint, Object result) {
        String info = AspectBeanUtil.typeMethodArgsInfo(joinPoint);
        this.logger.log(MiniLogLevel.getKeyBizLog(), "database-write,result:{},on {}", result, (Object)info);
    }

    @AfterThrowing(pointcut="dbWritePointcut()", throwing="exception")
    public void dbWrite(JoinPoint joinPoint, Throwable exception) {
        String info = AspectBeanUtil.typeMethodArgsInfo(joinPoint);
        this.logger.log(MiniLogLevel.getKeyBizLog(), "database-write-exception:{} on execute {}", (Object)exception.getMessage(), (Object)info);
    }
}

