/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.asserts;

import com.mini.framework.core.exception.BadDataException;
import com.mini.framework.core.exception.BadReqDelNoDataException;
import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.BadReqGetNoDataException;
import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.exception.HandleException;
import com.mini.framework.core.exception.HandleStoreException;
import com.mini.framework.core.exception.LogicException;
import com.mini.framework.core.exception.PermissionException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.SoaException;
import com.mini.framework.core.exception.ThirdException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.JudgeUtil;
import com.mini.framework.util.asserts.Require;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssertUtil {
    private static Logger logger = LogManager.getLogger(AssertUtil.class);
    private static final Map<Class<? extends CustomException>, StatusCode> cacheExceptionStatusMap = AssertUtil.createExceptionStatusMap();
    private static final Map<StatusCode, Class<? extends CustomException>> cacheStatusExceptionMap = AssertUtil.createStatusExceptionMap();
    private static final Map<Integer, Class<? extends CustomException>> cacheStatusIntExceptionMap = AssertUtil.createStatusIntExceptionMap();
    private static final int baseStatusCode = Status.Busy.def.code();

    private static Map<Class<? extends CustomException>, StatusCode> createExceptionStatusMap() {
        ConcurrentHashMap<Class<? extends CustomException>, StatusCode> statusExceptionMap = new ConcurrentHashMap<Class<? extends CustomException>, StatusCode>();
        statusExceptionMap.put(BadReqException.class, Status.BadReq.def);
        statusExceptionMap.put(BadDataException.class, Status.BadData.def);
        statusExceptionMap.put(BusyException.class, Status.Busy.def);
        statusExceptionMap.put(LogicException.class, Status.Logic.def);
        statusExceptionMap.put(PermissionException.class, Status.Permission.def);
        statusExceptionMap.put(ThirdException.class, Status.Third.def);
        statusExceptionMap.put(HandleException.class, Status.Handle.def);
        statusExceptionMap.put(SoaException.class, Status.Soa.def);
        statusExceptionMap.put(ServerException.class, Status.Server.def);
        return statusExceptionMap;
    }

    private static Map<Integer, Class<? extends CustomException>> createStatusIntExceptionMap() {
        Map<StatusCode, Class<? extends CustomException>> map = AssertUtil.createStatusExceptionMap();
        ConcurrentHashMap<Integer, Class<? extends CustomException>> statusIntExceptionMap = new ConcurrentHashMap<Integer, Class<? extends CustomException>>();
        for (Map.Entry<StatusCode, Class<? extends CustomException>> entry : map.entrySet()) {
            statusIntExceptionMap.put(entry.getKey().code(), entry.getValue());
        }
        return statusIntExceptionMap;
    }

    private static Map<StatusCode, Class<? extends CustomException>> createStatusExceptionMap() {
        ConcurrentHashMap<StatusCode, Class<? extends CustomException>> statusExceptionMap = new ConcurrentHashMap<StatusCode, Class<? extends CustomException>>();
        Map<Class<? extends CustomException>, StatusCode> map = AssertUtil.createExceptionStatusMap();
        for (Map.Entry<Class<? extends CustomException>, StatusCode> entry : map.entrySet()) {
            statusExceptionMap.put(entry.getValue(), entry.getKey());
        }
        return statusExceptionMap;
    }

    public static void assertStatusSupport(StatusCode statusCode, Class<? extends CustomException> clazz) {
        StatusCode defStatusCode = cacheExceptionStatusMap.get(clazz);
        int subCode = statusCode.code() - defStatusCode.code();
        boolean right = JudgeUtil.match(subCode >= 0 && subCode < baseStatusCode, Require.isTrue, new Object[0]);
        if (!right) {
            throw new UnsupportedException("\u81f4\u547d\u9519\u8bef\u72b6\u6001\u7c7b\u578b%s\u548c\u5f02\u5e38%s\u5bf9\u4e0d\u4e0a,\u6240\u4ee5\u4e0d\u652f\u6301", new Object[]{statusCode.code(), clazz});
        }
    }

    public static void assertAllNoBadReq(StatusCode status, Require require, String message, Object ... toAsserts) {
        boolean right = true;
        for (Object toAssert : toAsserts) {
            if (right &= JudgeUtil.match(toAssert, require, new Object[0])) continue;
            throw new BadReqException(status, message, toAsserts);
        }
    }

    public static <T> void assertBetween(Comparable<T> toAssert, Comparable<T> min, Comparable<T> max, String message) {
        boolean right = JudgeUtil.match(toAssert, Require.between, min, max);
        if (!right) {
            throw new BadReqException("%s:%s\u503c\u57df\u5e94\u8be5\u4e3a[%s,%s)", new Object[]{message, toAssert, min, max});
        }
    }

    public static <T> void assertValueIn(Object toAssert, String message, Object ... params) {
        if (params == null) {
            throw new UnsupportedException("\u4e0d\u80fd\u6ca1\u6709params\u53c2\u6570", new Object[]{message});
        }
        for (Object param : params) {
            if (!param.equals(toAssert)) continue;
            return;
        }
        throw new BadReqException(Status.BadReq.illParam, message, params);
    }

    public static boolean assertSameStatus(String message, Object ... toAssert) {
        AssertUtil.assertSupport(toAssert != null && toAssert.length > 0, "\u4e0d\u80fd\u4e0d\u4f20\u53c2\u9700\u8981\u7acb\u5373\u4fee\u6539\u4ee3\u7801", new Object[0]);
        boolean full = true;
        boolean empty = true;
        for (Object object : toAssert) {
            full &= object != null;
            empty &= object == null;
        }
        AssertUtil.assertNoBadReq(full || empty, Status.BadReq.illParam, message, new Object[0]);
        return full;
    }

    public static void assertAllNotNull(StatusCode status, String message, Object ... toAsserts) {
        AssertUtil.assertAllNoBadReq(status, Require.notNull, message, toAsserts);
    }

    public static void assertAnyNotNull(StatusCode status, String message, Object ... toAsserts) {
        AssertUtil.assertAnyNoBadReq(status, Require.notNull, message, toAsserts);
    }

    public static void assertAnyNoBadReq(StatusCode status, Require require, String message, Object ... toAsserts) {
        boolean right = false;
        for (Object toAssert : toAsserts) {
            if (!(right |= JudgeUtil.match(toAssert, require, new Object[0]))) continue;
            return;
        }
        throw new BadReqException(status, message, toAsserts);
    }

    public static void assertNoBadReq(boolean explain, StatusCode status, Supplier<String> supplier) {
        if (!explain) {
            throw new BadReqException(status, supplier.get(), new Object[0]);
        }
    }

    public static void assertNoBadReq(boolean explain, StatusCode status, String message, Object ... params) {
        AssertUtil.assertStatusSupport(status, BadReqException.class);
        if (!explain) {
            throw new BadReqException(status, message, params);
        }
    }

    public static void assertNotNull(Object obj, String message, Object ... params) {
        AssertUtil.assertNoBadReq(obj, Require.notNull, message, params);
    }

    public static void assertNotEmpty(Object obj, String message, Object ... params) {
        AssertUtil.assertNoBadReq(obj, Require.notEmpty, message, params);
    }

    public static <T> void assertNotEmpty(Collection<T> coll, String message, Object ... params) {
        AssertUtil.assertNoBadReq(coll != null ? 1 : 0, Require.notNull, message, params);
        for (Object object : params) {
            AssertUtil.assertNoBadReq(object, Require.notNull, message, params);
        }
    }

    public static void assertNoBadReq(Object obj, Require require, String message, Object ... params) {
        StatusCode status;
        String messagePrefix;
        switch (require) {
            case notEmpty: {
                messagePrefix = "\u6570\u636e\u4e0d\u80fd\u6ca1\u6709\u5185\u5bb9:";
                status = Status.BadReq.noReq;
                break;
            }
            case notNull: {
                messagePrefix = "\u4e0d\u80fd\u6ca1\u6709\u6570\u636e:";
                status = Status.BadReq.illParam;
                break;
            }
            default: {
                messagePrefix = "";
                status = Status.BadReq.noReq;
            }
        }
        AssertUtil.assertNoBadReq(JudgeUtil.match(obj, require, params), status, messagePrefix + message, params);
    }

    public static <T> void assertSwitchStatus(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BadReqException(Status.BadReq.conflictSwitchStatus, message, params);
        }
    }

    public static void haveParams(Object object, String message, Object ... params) {
        AssertUtil.assertNoBadReq(object != null, Status.BadReq.noReq, message, params);
    }

    public static void validateParams(boolean explain, String message, Object ... params) {
        AssertUtil.assertNoBadReq(explain, Status.BadReq.illParam, message, params);
    }

    public static void assertPermission(boolean explain, StatusCode status, String message, Object ... params) {
        AssertUtil.assertStatusSupport(status, PermissionException.class);
        if (!explain) {
            throw new PermissionException(status, message, params);
        }
    }

    public static void assertPermission(boolean explain, StatusCode status, String message, Consumer<CustomException> exceptHandle, Object ... params) {
        AssertUtil.assertMethodRequire(exceptHandle, "exceptHandle");
        AssertUtil.assertStatusSupport(status, PermissionException.class);
        if (!explain) {
            PermissionException except = new PermissionException(status, message, params);
            try {
                exceptHandle.accept((CustomException)except);
            }
            catch (Throwable e) {
                logger.error("\u5728\u51fa\u73b0\u9519\u8bef\u7684\u65f6\u5019\u518d\u6b64\u51fa\u9519", e);
            }
            throw except;
        }
    }

    public static void assertStoreSuccess(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new HandleStoreException(message, params);
        }
    }

    public static void assertGetHaveData(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BadReqGetNoDataException(message, params);
        }
    }

    public static void assertDelHaveData(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BadReqDelNoDataException(message, params);
        }
    }

    public static void assertNotFatal(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BusyException(message, params);
        }
    }

    public static void assertNotFatal(boolean explain, StatusCode busyCode, String message, Object ... params) {
        if (!explain) {
            throw new BusyException(busyCode, message, params);
        }
    }

    public static void assertNotFatalBug(boolean explain, String message, Object ... params) {
        message = "\u78b0\u5230\u8fd9\u4e2a\u95ee\u9898\u8bf7\u7acb\u5373\u4fee\u6539\u7a0b\u5e8f," + message;
        if (!explain) {
            throw new ServerException(Status.Server.fatalBug, message, params);
        }
    }

    public static void assertNotFatalDataConfig(boolean explain, StatusCode serverCode, String message, Object ... params) {
        AssertUtil.assertNotFatalBug(serverCode.subOf(Status.Server.dataConfig), "serverCode\u5fc5\u987b\u662fdataConfig\u4e0b\u9762\u5b50\u72b6\u6001\u7801", message);
        if (!explain) {
            throw new ServerException(serverCode, message, params);
        }
    }

    public static void assertNotFatalProgramConfig(boolean explain, StatusCode serverCode, String message, Object ... params) {
        AssertUtil.assertNotFatalBug(serverCode.subOf(Status.Server.programConfig), "serverCode\u5fc5\u987b\u662fprogramConfig\u4e0b\u9762\u5b50\u72b6\u6001\u7801", message);
        if (!explain) {
            throw new ServerException(serverCode, message, params);
        }
    }

    public static void assertSupport(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new UnsupportedException(message, params);
        }
    }

    public static void assertMethodRequire(Object param, String paramName) {
        AssertUtil.assertSupport(param != null, "\u6b64\u65b9\u6cd5\u5fc5\u987b\u4f20\u5165:[%s]\u53c2\u6570", paramName);
    }

    public static void assertParamsRequire() {
    }

    public static void assertMapDataComplete(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BadDataException(Status.BadData.noMapKeyData, message, params);
        }
    }

    public static void assertDataComplete(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BadDataException(Status.BadData.DataIncomplete, message, params);
        }
    }

    public static void assertDataMissFieldRequire(boolean explain, String message, Object ... params) {
        if (!explain) {
            throw new BadDataException(Status.BadData.missRequireFieldData, message, params);
        }
    }

    public static <E extends CustomException> void assertNormal(boolean explain, Supplier<E> exceptionSupplier) {
        AssertUtil.assertMethodRequire(exceptionSupplier, "exceptionSupplier");
        if (!explain) {
            throw (CustomException)exceptionSupplier.get();
        }
    }

    public static <E extends CustomException> void assertNormal(boolean explain, Function<String, E> exceptionSupplier, String message, Object ... params) throws E {
        AssertUtil.assertMethodRequire(exceptionSupplier, "exceptionSupplier");
        if (!explain) {
            String messageFinal = CustomException.format((String)message, (Object[])params);
            throw (CustomException)exceptionSupplier.apply(messageFinal);
        }
    }

    public static <O> O requireNonNullAsFatal(O object, String message, Object ... params) {
        AssertUtil.simpleAssertByStatus(object != null, Status.Server.fatalBug, message, params);
        return object;
    }

    public static <O> O requireNonNullAsBadReq(O object, StatusCode badreq, String message, Object ... params) {
        AssertUtil.assertNotFatalBug(badreq.subOf(Status.BadReq.def), "badreq\u5fc5\u987b\u662fBadReq\u4e0b\u9762\u5b50\u72b6\u6001\u7801", message);
        AssertUtil.simpleAssertByStatus(object != null, badreq, message, params);
        return object;
    }

    public static <O> O requireNonNull(O object, StatusCode status, String message, Object ... params) {
        AssertUtil.simpleAssertByStatus(object != null, status, message, params);
        return object;
    }

    public static void simpleAssertByStatus(boolean explain, StatusCode status, String message, Object ... params) {
        if (explain) {
            return;
        }
        int superCode = status.code() - status.code() % baseStatusCode;
        Class<? extends CustomException> customExceptionClass = cacheStatusIntExceptionMap.get(superCode);
        if (BadReqException.class == customExceptionClass) {
            throw new BadReqException(status, message, params);
        }
        if (BadDataException.class == customExceptionClass) {
            throw new BadDataException(status, message, params);
        }
        if (BusyException.class == customExceptionClass) {
            throw new BusyException(status, message, params);
        }
        if (LogicException.class == customExceptionClass) {
            throw new LogicException(status, message, params);
        }
        if (PermissionException.class == customExceptionClass) {
            throw new PermissionException(status, message, params);
        }
        if (ThirdException.class == customExceptionClass) {
            throw new ThirdException(status, message, params);
        }
        if (HandleException.class == customExceptionClass) {
            throw new HandleException(status, message, params);
        }
        if (ServerException.class == customExceptionClass) {
            throw new ServerException(status, message, params);
        }
        throw new UnsupportedException(customExceptionClass + ",statusCode:" + status.code() + message, params);
    }

    private static String format(String message, Object ... paramsMsg) {
        try {
            return String.format(message, paramsMsg);
        }
        catch (Throwable e) {
            return "\u51fa\u73b0\u4e25\u91cd\u95ee\u9898\u9700\u8981\u68c0\u67e5format:[" + message + "],\u548c\u53c2\u6570\u8868:" + Arrays.toString(paramsMsg);
        }
    }

    public static <E extends CustomException> void handleCustomException(boolean explain, Function<String, E> errorHandle, String message, Object ... params) throws E {
        if (!explain) {
            String messageFinal = CustomException.format((String)message, (Object[])params);
            throw (CustomException)errorHandle.apply(messageFinal);
        }
    }
}

