/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean.desc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mini.framework.util.bean.BeanUtil;
import com.mini.framework.util.bean.desc.DescUtil;
import com.mini.framework.util.bean.desc.Descable;
import com.mini.framework.util.bean.desc.FieldDesc;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DescSerializer
implements JsonSerializer<Descable> {
    private String suffix;
    private String nullDesc;
    private Supplier<Gson> gsonSupplier;

    public DescSerializer(String suffix, Supplier<Gson> gsonSupplier, String nullDesc) {
        this.suffix = suffix;
        this.gsonSupplier = gsonSupplier;
        this.nullDesc = nullDesc;
    }

    public JsonElement serialize(Descable desc, Type typeOfSrc, JsonSerializationContext context) {
        Map<String, Object> map = BeanUtil.beanToMap(desc);
        List<Field> fields = BeanUtil.getAllField(desc);
        Map<String, FieldDesc> keyDescMap = fields.stream().collect(Collectors.toMap(field -> field.getName() + this.suffix, field -> DescUtil.getDesces(field, this.nullDesc)));
        map.putAll(keyDescMap);
        LinkedHashMap newMap = new LinkedHashMap();
        map.keySet().stream().sorted().forEach(key -> newMap.put(key, map.get(key)));
        Gson gson = this.gsonSupplier.get();
        JsonElement element = gson.toJsonTree(newMap);
        return element;
    }
}

