/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache.annotation.springboot2;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.cache.annotation.springboot2.AbstractRedisCacheSupport;
import com.mini.framework.util.cache.annotation.springboot2.CustomRedisCache;
import java.time.Duration;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class CustomRedisCacheManager
extends RedisCacheManager {
    private RedisConnectionFactory redisConnectionFactory;
    private RedisCacheConfiguration baseCacheConfig;

    public CustomRedisCacheManager(CacheKeyPrefix cacheKeyPrefix, RedisConnectionFactory redisConnectionFactory, RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
        this.baseCacheConfig = AbstractRedisCacheSupport.createBaseCacheConfiguration(cacheKeyPrefix);
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        String[] splits = name.split("#");
        AssertUtil.assertSupport(splits.length == 2, "\u7f13\u5b58key:[%s]\u6709\u4e14\u53ea\u80fd\u5305\u542b1\u4e2a#", name);
        try {
            Long expire = Long.parseLong(splits[1]);
            RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.redisConnectionFactory);
            RedisCacheConfiguration customCacheConfig = this.baseCacheConfig.entryTtl(Duration.ofSeconds(expire));
            return new CustomRedisCache(name, cacheWriter, customCacheConfig);
        }
        catch (NumberFormatException e) {
            throw new BusyException(Status.Busy.fatalBug, "\u7f13\u5b58key:[%s]\u4e2d#\u540e\u9762\u6587\u5b57:[%s]\u7684\u5fc5\u987b\u662f\u6574\u6570\u5355\u4f4d\u79d2", new Object[]{name, splits[1]});
        }
    }
}

