/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache.prepare.merge;

import com.mini.framework.util.cache.prepare.merge.IncrementPrepareCacheAsyncMergeFlow;
import com.mini.framework.util.cache.prepare.merge.data.PrepareAtomCacheExecutor;
import com.mini.framework.util.cache.prepare.merge.data.RedisKeyGenerator;
import com.mini.framework.util.cache.prepare.merge.data.WorkDelayLock;
import com.mini.framework.util.thread.AbstractAsyncThreadExecutor;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.support.atomic.RedisAtomicInteger;

public class RedisIncrementPrepareCacheAsyncMergeFlow
extends IncrementPrepareCacheAsyncMergeFlow {
    private RedisTemplate redisTemplate;
    private int errorMaxDelayMillis;
    private RedisKeyGenerator counterGenerator;
    private RedisKeyGenerator workHolderGenerator;

    public RedisIncrementPrepareCacheAsyncMergeFlow(String flowName, AbstractAsyncThreadExecutor asyncExecutor, RedisTemplate redisTemplate, RedisKeyGenerator counterGenerator, RedisKeyGenerator workHolderGenerator, int errorMaxDelayMillis) {
        super(flowName, asyncExecutor, RedisIncrementPrepareCacheAsyncMergeFlow.createRedisPrepareCacheExecute(redisTemplate, counterGenerator), RedisIncrementPrepareCacheAsyncMergeFlow.createRedisLock(redisTemplate, workHolderGenerator, errorMaxDelayMillis));
        this.redisTemplate = redisTemplate;
        this.errorMaxDelayMillis = errorMaxDelayMillis;
        this.counterGenerator = counterGenerator;
        this.workHolderGenerator = workHolderGenerator;
    }

    private static WorkDelayLock createRedisLock(final RedisTemplate redisTemplate, final RedisKeyGenerator keyGenerator, final int errorMaxDelayMillis) {
        return new WorkDelayLock(){

            @Override
            public Optional<String> triesLock(String key, String workerName) {
                String threadName = Thread.currentThread().getName();
                String redisKey = keyGenerator.create(key);
                ValueOperations valueOps = redisTemplate.opsForValue();
                Boolean working = valueOps.setIfAbsent((Object)redisKey, (Object)threadName, Duration.ofMillis(errorMaxDelayMillis));
                return working != false ? Optional.empty() : Optional.ofNullable(valueOps.get((Object)redisKey)).map(Object::toString);
            }

            @Override
            public void releaseLock(String key) {
                String redisKey = keyGenerator.create(key);
                redisTemplate.opsForList();
                redisTemplate.delete((Object)redisKey);
            }
        };
    }

    private static PrepareAtomCacheExecutor createRedisPrepareCacheExecute(final RedisTemplate redisTemplate, final RedisKeyGenerator keyGenerator) {
        return new PrepareAtomCacheExecutor(){

            @Override
            public int writeIncrement(String key, int increment) {
                String redisKey = keyGenerator.create(key);
                RedisAtomicInteger counter = new RedisAtomicInteger(redisKey, redisTemplate.getConnectionFactory());
                return counter.addAndGet(increment);
            }

            @Override
            public int querySurplus(String key) {
                String redisKey = keyGenerator.create(key);
                RedisAtomicInteger counter = new RedisAtomicInteger(redisKey, redisTemplate.getConnectionFactory());
                return counter.get();
            }

            @Override
            public int cutSurplus(String key) {
                String redisKey = keyGenerator.create(key);
                RedisAtomicInteger counter = new RedisAtomicInteger(redisKey, redisTemplate.getConnectionFactory());
                return counter.getAndSet(0);
            }
        };
    }
}

