/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.code;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.ArrayUtils;

public class UnionCodeUtil {
    public static final String codeAll = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String codeRetain = "hR4s6T9q";
    public static final String codeScope = UnionCodeUtil.replaceRetain("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    private int mapSize;
    private int codeLength;

    private static String fillRetain(String sourseCode, int codeLength) {
        AssertUtil.simpleAssertByStatus(sourseCode.length() <= codeLength, Status.Logic.def, "\u6e90code:[%s]\u957f\u5ea6\u5df2\u5927\u4e8e\u8981\u586b\u5145\u7684\u957f\u5ea6%s", sourseCode, codeLength);
        while (sourseCode.length() < codeLength) {
            int disturb = UnionCodeUtil.createDisturb(sourseCode);
            sourseCode = sourseCode + codeRetain.charAt((disturb + disturb * sourseCode.length() * codeLength) % codeRetain.length());
        }
        return sourseCode;
    }

    private static int createDisturb(String param) {
        int i;
        long disturb = 1L;
        for (i = 0; i < param.length(); ++i) {
            disturb *= (long)param.charAt(i);
        }
        for (i = 0; i < param.length(); ++i) {
            disturb /= 32L;
        }
        return Math.abs((int)disturb);
    }

    private static String replaceRetain(String sourseCode) {
        String targetCode = sourseCode;
        for (int i = 0; i < codeRetain.length(); ++i) {
            targetCode = targetCode.replace(String.valueOf(codeRetain.charAt(i)), "");
        }
        return targetCode;
    }

    public UnionCodeUtil(int mapSize, int codeLength) {
        this.mapSize = mapSize;
        this.codeLength = codeLength;
    }

    public int[] decode(String codeList) {
        AssertUtil.simpleAssertByStatus(codeList != null, Status.Logic.def, "union\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        codeList = UnionCodeUtil.replaceRetain(codeList);
        long lon = 0L;
        for (int i = 0; i < codeList.length(); ++i) {
            lon *= (long)codeScope.length();
            char code = codeList.charAt(i);
            int val = codeScope.indexOf(code);
            AssertUtil.simpleAssertByStatus(val >= 0, Status.Handle.enDeCode, "[%s]\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684unionCode", codeList);
            lon += (long)val;
        }
        String str = String.valueOf(lon);
        int strLen = str.length();
        int[] sourses = new int[this.mapSize];
        int offset = 1;
        try {
            for (int i = 0; i < sourses.length; ++i) {
                int len = str.charAt(strLen - this.mapSize + i) - 48 + 1;
                sourses[i] = Integer.parseInt(str.substring(offset, offset + len));
                offset += len;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HandleEnDeCodeException((Throwable)e, "[%s]\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684unionCode", new Object[]{codeList});
        }
        this.viledateFormat(sourses);
        ArrayUtils.reverse((int[])sourses);
        return sourses;
    }

    private void viledateFormat(int ... sourses) {
        AssertUtil.simpleAssertByStatus(sourses.length == this.mapSize, Status.Handle.enDeCode, "\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u4e3a%s\u4f4d", this.mapSize);
        for (int sourse : sourses) {
            AssertUtil.simpleAssertByStatus(sourse > 0, Status.Handle.enDeCode, "sourse[%s]\u5fc5\u987b\u5927\u4e8e0", sourse);
        }
    }

    public String encode(int ... sourses) {
        this.viledateFormat(sourses);
        ArrayUtils.reverse((int[])sourses);
        String suffix = "";
        String midfix = "";
        int sum = 0;
        for (int sourse : sourses) {
            suffix = suffix + (UnionCodeUtil.length(sourse) - 1);
            midfix = midfix + sourse;
            sum += sourse;
        }
        String longChar = sum % 9 + 1 + midfix + suffix;
        String code = "";
        for (long lon = Long.parseLong(longChar); lon > 0L; lon /= (long)codeScope.length()) {
            long yu = lon % (long)codeScope.length();
            code = codeScope.charAt((int)yu) + code;
        }
        code = UnionCodeUtil.fillRetain(code, this.codeLength);
        return code;
    }

    public static int length(int sourse) {
        return String.valueOf(sourse).toString().length();
    }
}

