/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateRange {
    private Date minDate;
    private Date maxDate;

    public static DateRange create(Date minDate, Date maxDate) {
        DateRange instance = new DateRange();
        instance.maxDate = maxDate;
        instance.minDate = minDate;
        return instance;
    }

    public DateRange limitUpperDate(Date upperLimitDate) {
        Date maxDate = this.maxDate.before(upperLimitDate) ? this.maxDate : upperLimitDate;
        maxDate = maxDate.before(this.minDate) ? this.minDate : maxDate;
        return DateRange.create(this.minDate, maxDate);
    }

    public long showTimeScopeMilliseconds() {
        return Math.max(0L, this.maxDate.getTime() - this.minDate.getTime());
    }

    public long showEffectTimes() {
        return this.maxDate.getTime() - this.minDate.getTime();
    }

    public Optional<DateRange> intersect(DateRange other) {
        BiFunction<Date, Date, Date> max = (a, b) -> a.after((Date)b) ? a : b;
        BiFunction<Date, Date, Date> min = (a, b) -> a.before((Date)b) ? a : b;
        Date newMin = max.apply(this.minDate, other.minDate);
        Date newMax = min.apply(this.maxDate, other.maxDate);
        return Optional.of(DateRange.create(newMin, newMax)).filter(range -> range.showEffectTimes() >= 0L);
    }

    public List<DateRange> diffFromOther(DateRange other) {
        ArrayList<DateRange> list = new ArrayList<DateRange>();
        BiFunction<Date, Date, Date> findMax = (a, b) -> a.after((Date)b) ? a : b;
        BiFunction<Date, Date, Date> findMin = (a, b) -> a.before((Date)b) ? a : b;
        if (other.haveTimeScope()) {
            if (this.minDate.before(other.minDate)) {
                list.add(DateRange.create(this.minDate, findMin.apply(other.minDate, this.maxDate)));
            }
            if (this.maxDate.after(other.maxDate)) {
                list.add(DateRange.create(findMax.apply(other.maxDate, this.minDate), this.maxDate));
            }
        } else {
            list.add(this);
        }
        return list;
    }

    public List<Date> chuckMapUseFixedMinute(boolean rightClosed) {
        return this.chuckMapUseFixedMinute(rightClosed, Function.identity());
    }

    public <R> List<R> chuckMapUseFixedMinute(int minutes, boolean rightClosed, Function<Date, R> resultMapper) {
        return this.chuckMapUseFixedTime((long)minutes * 60L * 1000L, rightClosed, resultMapper);
    }

    public <R> List<R> chuckMapUseFixedMinute(boolean rightClosed, Function<Date, R> resultMapper) {
        return this.chuckMapUseFixedMinute(1, rightClosed, resultMapper);
    }

    public List<Date> chuckMapUseFixedMinute10(boolean rightClosed) {
        return this.chuckMapUseFixedMinute10(rightClosed, Function.identity());
    }

    public <R> List<R> chuckMapUseFixedMinute10(boolean rightClosed, Function<Date, R> resultMapper) {
        return this.chuckMapUseFixedMinute(10, rightClosed, resultMapper);
    }

    public <R> List<R> chuckMapUseFixedHour(boolean rightClosed, Function<Date, R> resultMapper) {
        return this.chuckMapUseFixedMinute(60, rightClosed, resultMapper);
    }

    public List<Date> chuckMapUseFixedHour(boolean rightClosed) {
        return this.chuckMapUseFixedHour(rightClosed, Function.identity());
    }

    public <R> List<R> chuckMapUseFixedTime(long fixedTime, boolean rightClosed, Function<Date, R> resultMapper) {
        return this.chuckMapUseFixedTime(fixedTime, rightClosed).stream().map(resultMapper).collect(Collectors.toList());
    }

    public List<Date> chuckMapUseFixedTime(long fixedTime, boolean rightClosed) {
        AssertUtil.assertNotFatal(fixedTime > 0L, "fixedTime\u5fc5\u987b\u5927\u4e8e0", new Object[0]);
        ArrayList<Date> list = new ArrayList<Date>();
        Date date = this.getDateStartUseFixedTime(this.minDate, fixedTime);
        while (!date.after(this.maxDate)) {
            if (this.matchRange(date, rightClosed)) {
                list.add(date);
            }
            date = new Date(date.getTime() + fixedTime);
        }
        return list;
    }

    private Date getDateStartUseFixedTime(Date originDate, long fixedTime) {
        long count = originDate.getTime() / fixedTime;
        return new Date(count * fixedTime);
    }

    public List<DateRange> chuckFlatByNatureDayDate() {
        Date minDayDate = DateUtil.getCleanedDateUnit(TimeSectionType.day, this.minDate);
        Date maxDayDate = DateUtil.getCleanedDateUnit(TimeSectionType.day, this.maxDate);
        Date minNextDayDate = DateUtil.addTimeUnit(TimeSectionType.day, minDayDate, 1);
        ArrayList<DateRange> ranges = new ArrayList<DateRange>();
        if (maxDayDate.equals(minDayDate)) {
            ranges.add(this);
        } else if (maxDayDate.after(minDayDate)) {
            ranges.add(DateRange.create(this.minDate, minNextDayDate));
            ranges.addAll(DateRange.create(minNextDayDate, this.maxDate).chuckFlatByNatureDayDate());
        }
        return ranges;
    }

    public String toString() {
        String format = "yyyy-MM-dd HH:mm:ss";
        return String.format("[%s->%s)", DateFormatUtils.format((Date)this.minDate, (String)format), DateFormatUtils.format((Date)this.maxDate, (String)format));
    }

    public boolean matchRangeClosed(Date target) {
        return this.matchRange(target, true);
    }

    public boolean matchRange(Date target, boolean rightClosed) {
        AssertUtil.assertMethodRequire(target, "target");
        boolean notRightClosed = !target.before(this.minDate) && target.before(this.maxDate);
        return notRightClosed || rightClosed && target.equals(this.maxDate);
    }

    public boolean haveTimeScope() {
        return this.showTimeScopeMilliseconds() > 0L;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }
}

