/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.framework.util.type.EnumTypeShower;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.DateFormatUtils;

public enum DateScopeItems implements EnumTypeShower<DateScopeItems>
{
    allOfAll(TimeSectionType.all, TimeSectionType.all, "\u6709\u53f2\u4ee5\u6765", "\u6709\u53f2\u4ee5\u6765"),
    yearOfAll(TimeSectionType.all, TimeSectionType.year, "yyyy\u5e74", "\u6bcf\u5e74"),
    seasonOfAll(TimeSectionType.all, TimeSectionType.season, null, "\u6bcf\u5b63"),
    monthOfAll(TimeSectionType.all, TimeSectionType.month, "yyyy\u5e74MM\u6708", "\u6bcf\u6708"),
    weekOfAll(TimeSectionType.all, TimeSectionType.week, null, "\u6bcf\u5468"),
    dayOfAll(TimeSectionType.all, TimeSectionType.day, "yyyy\u5e74MM\u6708dd\u65e5", "\u6bcf\u5929"),
    hourOfAll(TimeSectionType.all, TimeSectionType.hour, "yyyy\u5e74MM\u6708dd\u65e5HH\u70b9", "\u6bcf\u5c0f\u65f6"),
    seasonOfYear(TimeSectionType.year, TimeSectionType.season, null, "\u5e74\u4e2d\u5404\u4e2a\u5b63\u8282"),
    monthOfYear(TimeSectionType.year, TimeSectionType.month, "MM\u6708", "\u5e74\u4e2d\u5404\u4e2a\u6708"),
    weekOfYear(TimeSectionType.year, TimeSectionType.week, null, "\u5e74\u4e2d\u5404\u5468"),
    dayOfYear(TimeSectionType.year, TimeSectionType.day, "MM\u6708dd\u65e5", "\u5e74\u4e2d\u5404\u5929"),
    hourOfYear(TimeSectionType.year, TimeSectionType.hour, "MM\u6708dd\u65e5HH\u70b9", "\u5e74\u4e2d\u5404\u4e2a\u5c0f\u65f6"),
    monthOfSeason(TimeSectionType.season, TimeSectionType.month, null, "\u5b63\u4e2d\u5404\u4e2a\u6708"),
    weekOfSeason(TimeSectionType.season, TimeSectionType.week, null, "\u5b63\u4e2d\u5404\u5468"),
    dayOfSeason(TimeSectionType.season, TimeSectionType.day, null, "\u5b63\u4e2d\u5404\u5929"),
    hourOfSeason(TimeSectionType.season, TimeSectionType.hour, null, "\u5b63\u4e2d\u5404\u4e2a\u5c0f\u65f6"),
    weekOfMonth(TimeSectionType.month, TimeSectionType.week, null, "\u6708\u4e2d\u5404\u5468"),
    dayOfMonth(TimeSectionType.month, TimeSectionType.day, "dd\u53f7", "\u6708\u4e2d\u5404\u5929"),
    hourOfMonth(TimeSectionType.month, TimeSectionType.hour, "dd\u53f7HH\u70b9", "\u6708\u4e2d\u5404\u4e2a\u5c0f\u65f6"),
    dayOfWeek(TimeSectionType.week, TimeSectionType.day, null, "\u5468\u4e2d\u5404\u5929"),
    hourOfWeek(TimeSectionType.week, TimeSectionType.hour, null, "\u5468\u4e2d\u5404\u4e2a\u5c0f\u65f6"),
    hourOfDay(TimeSectionType.day, TimeSectionType.hour, "HH\u70b9", "\u5929\u4e2d\u5404\u4e2a\u5c0f\u65f6");

    private TimeSectionType scope;
    private TimeSectionType item;
    private String desc;
    private String simpleItemTitleFormat;
    public static Map<String, DateScopeItems> keyMap;

    private DateScopeItems(TimeSectionType scope, TimeSectionType item, String simpleNameFormat, String desc) {
        this.scope = scope;
        this.item = item;
        this.simpleItemTitleFormat = simpleNameFormat;
        this.desc = desc;
    }

    public TimeSectionType item() {
        return this.item;
    }

    public TimeSectionType scope() {
        return this.scope;
    }

    public String desc() {
        return this.desc;
    }

    public String simpleItemTitleFormat() {
        return this.simpleItemTitleFormat;
    }

    private static Map<String, DateScopeItems> createKeyMap() {
        ConcurrentHashMap<String, DateScopeItems> map = new ConcurrentHashMap<String, DateScopeItems>();
        for (DateScopeItems pair : DateScopeItems.values()) {
            map.put(DateScopeItems.createKey(pair.scope, pair.item), pair);
        }
        return map;
    }

    private static String createKey(TimeSectionType scope, TimeSectionType item) {
        AssertUtil.assertMethodRequire(scope, "scope");
        AssertUtil.assertMethodRequire(item, "item");
        return item + " in " + scope;
    }

    public static DateScopeItems verifyPair(TimeSectionType scope, TimeSectionType item) {
        DateScopeItems pair = DateScopeItems.matchPair(scope, item);
        AssertUtil.assertNoBadReq(pair != null, Status.BadReq.unsupport, "\u4e0d\u652f\u6301\u7684\u5206\u7ec4\u65e5\u671f:[%s]\u76ee\u524d\u652f\u6301\u7684\u5206\u7ec4\u65e5\u671f\u662f:%s", DateScopeItems.createKey(scope, item), Arrays.toString(DateScopeItems.values()));
        return pair;
    }

    public static DateScopeItems fromScopeItem(TimeSectionType scope, TimeSectionType item) {
        return Stream.of(DateScopeItems.values()).filter(bean -> bean.matchItem(item)).filter(bean -> bean.matchScope(scope)).findFirst().orElseThrow(() -> new ServerException("scope:[%s],item:[%s]\u6ca1\u6709\u5339\u914d\u7684DateScopeItems", new Object[]{scope, item}));
    }

    public boolean matchScope(TimeSectionType scope) {
        return this.scope == scope;
    }

    public boolean matchItem(TimeSectionType item) {
        return this.item == item;
    }

    public static DateScopeItems matchPair(TimeSectionType scope, TimeSectionType item) {
        return keyMap.get(DateScopeItems.createKey(scope, item));
    }

    public String countSimpleItemTitle(Date pointDate) {
        if (this.simpleItemTitleFormat != null) {
            return DateFormatUtils.format((Date)pointDate, (String)this.simpleItemTitleFormat);
        }
        DateScopeItems type = this;
        switch (type) {
            case seasonOfAll: {
                return DateFormatUtils.format((Date)pointDate, (String)"yy\u5e74") + DateUtil.indexSeasonNameQsort(pointDate);
            }
            case weekOfYear: {
                return String.format("\u7b2c%s\u5468", DateUtil.indexWeekOfYear(pointDate));
            }
            case seasonOfYear: {
                return DateUtil.indexSeasonNameQsort(pointDate);
            }
            case weekOfMonth: {
                return String.format("\u7b2c%s\u5468", DateUtil.indexWeekOfMonth(pointDate));
            }
            case dayOfWeek: {
                return DateUtil.indexDayOfWeekSimpleName(pointDate);
            }
            case hourOfWeek: {
                return hourOfDay.countSimpleItemTitle(pointDate) + "-" + dayOfWeek.countSimpleItemTitle(pointDate);
            }
        }
        return this.name();
    }

    @Override
    public void fillFieldToMap(Map<String, Object> map) {
        map.put("scope", this.scope);
        map.put("item", this.item);
        map.put("desc", this.desc);
        map.put("simpleItemTitleFormat", this.simpleItemTitleFormat);
    }

    static {
        keyMap = DateScopeItems.createKeyMap();
    }
}

