/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.export.ExcelColumnDeclare;
import com.mini.framework.util.file.ExcelUtil;
import com.mini.framework.util.function.PredicateSpread;
import com.mini.framework.util.string.gson.GsonDataReader;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExcelExportSupport
extends GsonDataReader {
    public static ExcelExportSupport build(Object data) {
        ExcelExportSupport ins = new ExcelExportSupport();
        ins.init(data);
        return ins;
    }

    @Override
    protected Gson currGsonUtil() {
        GsonBuilder builder = new GsonBuilder().setDateFormat(1).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(DateUtil.toSecondsString(src));
            }
        });
        return builder.disableHtmlEscaping().create();
    }

    public byte[] exportAsBytes(String listNamePath, List<ExcelColumnDeclare> columns) {
        columns = columns.stream().filter(PredicateSpread.ofNegate(ExcelColumnDeclare::skip)).collect(Collectors.toList());
        int columnsSize = columns.size();
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>();
        columns = columns.stream().sorted(Comparator.comparing(ExcelColumnDeclare::sorter)).collect(Collectors.toList());
        List<String> dataPaths = columns.stream().map(ExcelColumnDeclare::dataPath).collect(Collectors.toList());
        List<Map<String, Object>> listMapDataForOut = this.getFromListFrame(listNamePath, dataPaths);
        List<Map<String, String>> dataRows = listMapDataForOut.stream().map(item -> new HashMap(columnsSize)).collect(Collectors.toList());
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            String columnKey = "column" + columnIndex;
            ExcelColumnDeclare column = columns.get(columnIndex);
            String columnDataPath = column.dataPath();
            titles.put(columnKey, column.title());
            for (int rowIndex = 0; rowIndex < listMapDataForOut.size(); ++rowIndex) {
                Map<String, Object> mapDataForOut = listMapDataForOut.get(rowIndex);
                Map<String, String> dataRow = dataRows.get(rowIndex);
                String outValue = Optional.ofNullable(mapDataForOut.get(columnDataPath)).map(Object::toString).map(ExcelColumnDeclare.Support.contentSupplierFromOrigin(column)).orElse(column.defaultValue());
                dataRow.put(columnKey, outValue);
            }
        }
        return ExcelUtil.writeToByte(titles, dataRows);
    }
}

