/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class ListLong {
    private final List<Long> value;

    public ListLong(List<Long> value) {
        AssertUtil.assertMethodRequire(value, "value");
        this.value = value;
    }

    public static ListLong of(long ... longs) {
        return ListLong.of(LongStream.of(longs).boxed().collect(Collectors.toSet()));
    }

    public static ListLong of(Long ... longs) {
        return ListLong.of(Stream.of(longs).collect(Collectors.toSet()));
    }

    public static ListLong of(Collection<Long> coll) {
        return ListLong.of(new ArrayList<Long>(coll));
    }

    public static <L> ListLong of(Function<L, Long> longGetter, Collection<L> coll) {
        return ListLong.of(coll.stream().map(longGetter).collect(Collectors.toList()));
    }

    public ListLong copy() {
        return ListLong.of(this.out());
    }

    public List<Long> out() {
        return this.value;
    }

    public Stream<Long> stream() {
        return this.value.stream();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }
}

