/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SetInt {
    private final Set<Integer> value;

    public SetInt(Set<Integer> value) {
        this.value = value;
    }

    public static SetInt of(int ... ints) {
        return SetInt.of(IntStream.of(ints).boxed().collect(Collectors.toSet()));
    }

    public static SetInt of(Integer ... ints) {
        return SetInt.of(Stream.of(ints).collect(Collectors.toSet()));
    }

    public static SetInt of(Set<Integer> set) {
        AssertUtil.assertMethodRequire(set, "set");
        return new SetInt(set);
    }

    public static SetInt of(Collection<Integer> coll) {
        return SetInt.of(new HashSet<Integer>(coll));
    }

    public static <L> SetInt of(Function<L, Integer> intGetter, Collection<L> coll) {
        return SetInt.of(coll.stream().map(intGetter).collect(Collectors.toSet()));
    }

    public SetInt copy() {
        return SetInt.of(this.out());
    }

    public Set<Integer> out() {
        return this.value;
    }

    public Stream<Integer> stream() {
        return this.value.stream();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

