/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http.full;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.full.FullHttpResponse;
import com.mini.framework.util.http.full.HttpMethod;
import com.mini.framework.util.params.MapParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class FullHttpRequest {
    private HttpMethod method;
    private String url;

    public FullHttpRequest(HttpMethod method, String url) {
        this.method = method;
        this.url = url;
    }

    private HttpEntity asEntity(String body) {
        return new StringEntity(body, "utf-8");
    }

    private HttpEntity asEntity(MapParams queries) {
        List list = queries.toStringMap().entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        try {
            return new UrlEncodedFormEntity(list, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServerException((Throwable)e, "\u751f\u6210url encode\u53c2\u6570\u9519\u8bef params:%s", new Object[]{queries.toStringMap()});
        }
    }

    private HttpRequestBase asRequest(Map<String, String> queries, Optional<String> bodyOptional) {
        return this.asRequest(MapParams.build().params(queries), bodyOptional);
    }

    private HttpRequestBase asRequest(MapParams queries, Optional<String> bodyOptional) {
        String urlWithParams = queries.toUrlParams(this.url);
        Function<HttpEntityEnclosingRequestBase, HttpRequestBase> useBodyOptional = request -> {
            bodyOptional.map(this::asEntity).ifPresent(arg_0 -> ((HttpEntityEnclosingRequestBase)request).setEntity(arg_0));
            return request;
        };
        Function<HttpEntityEnclosingRequestBase, HttpRequestBase> bodyAttachQueries = request -> {
            request.setEntity(this.asEntity(queries));
            return request;
        };
        switch (this.method) {
            case DELETE: {
                return FullHttpRequest.setConfig((HttpRequestBase)new HttpDelete(urlWithParams));
            }
            case GET: {
                return FullHttpRequest.setConfig((HttpRequestBase)new HttpGet(urlWithParams));
            }
            case PUT: {
                HttpPut put = new HttpPut(urlWithParams);
                useBodyOptional.apply((HttpEntityEnclosingRequestBase)put);
                return FullHttpRequest.setConfig((HttpRequestBase)put);
            }
            case POST: {
                HttpPost post = new HttpPost(urlWithParams);
                useBodyOptional.apply((HttpEntityEnclosingRequestBase)post);
                return FullHttpRequest.setConfig((HttpRequestBase)post);
            }
        }
        throw new ServerException(Status.Server.fatalBug, "\u4e0d\u77e5\u9053\u7684method:%s", new Object[]{this.method});
    }

    private static HttpRequestBase setConfig(HttpRequestBase request) {
        request.setConfig(FullHttpRequest.createDefaultRequestConfig());
        return request;
    }

    private static RequestConfig createDefaultRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(6000);
        builder.setConnectionRequestTimeout(60000);
        builder.setSocketTimeout(12000);
        builder.setMaxRedirects(5);
        return builder.build();
    }

    public FullHttpResponse execute(Map<String, String> headers, Map<String, String> queries) {
        return this.execute(headers, queries, Optional.empty());
    }

    public FullHttpResponse execute(Map<String, String> headers, Map<String, String> queries, Optional<String> bodyOptional) {
        AssertUtil.assertMethodRequire(headers, "headers");
        AssertUtil.assertMethodRequire(queries, "queries");
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpRequestBase request = this.asRequest(queries, bodyOptional);
        headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).setHeader(arg_0, arg_1));
        BasicHttpContext context = new BasicHttpContext();
        queries.forEach((arg_0, arg_1) -> ((HttpContext)context).setAttribute(arg_0, arg_1));
        try {
            CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)request, (HttpContext)context);
            int responseStatus = response.getStatusLine().getStatusCode();
            HashMap<String, String> responseHeaders = new HashMap<String, String>(20);
            Stream.of(response.getAllHeaders()).forEach(header -> responseHeaders.put(header.getName(), header.getValue()));
            InputStream content = response.getEntity().getContent();
            String responseBody = IOUtils.toString((InputStream)content, (String)"utf-8");
            return new FullHttpResponse(this, responseStatus, responseHeaders, responseBody);
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5728\u53d1http:[%s]\u8bf7\u6c42\u65f6\u51fa\u9519", new Object[]{this});
        }
    }

    public FullHttpRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public FullHttpRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

