/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http.linked;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.linked.HttpClientHelper;
import com.mini.framework.util.http.linked.HttpMethod;
import com.mini.framework.util.http.linked.HttpResponse;
import com.mini.framework.util.params.MapParams;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpRequest {
    public static final String post = "POST";
    public static final String get = "GET";
    public static final String delete = "DELETE";
    public static final String put = "PUT";
    private HttpMethod method;
    private String endpoint;
    private String path;
    private LinkedHashMap<String, String> header = new LinkedHashMap();
    private LinkedHashMap<String, String> query = new LinkedHashMap();
    private LinkedHashMap<String, String> body = new LinkedHashMap();

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LinkedHashMap<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(LinkedHashMap<String, String> header) {
        this.header = header;
    }

    public LinkedHashMap<String, String> getQuery() {
        return this.query;
    }

    public void setQuery(LinkedHashMap<String, String> query) {
        this.query = query;
    }

    public LinkedHashMap<String, String> getBody() {
        return this.body;
    }

    public void setBody(LinkedHashMap<String, String> body) {
        this.body = body;
    }

    public static HttpRequest create() {
        return new HttpRequest();
    }

    public HttpRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpRequest endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpRequest path(String path) {
        this.path = path;
        return this;
    }

    public HttpRequest url(String urlPath) {
        try {
            URL url = new URL(urlPath);
            return this.endpoint(url.getProtocol() + "://" + url.getHost()).path(url.getFile());
        }
        catch (MalformedURLException e) {
            throw new BadReqException(Status.BadReq.illUrlSyntax, "url:[%s]\u683c\u5f0f\u9519\u8bef", new Object[]{urlPath});
        }
    }

    public HttpRequest post(String path) {
        return this.method(HttpMethod.post).path(path);
    }

    public HttpRequest get(String path) {
        return this.method(HttpMethod.get).path(path);
    }

    public HttpRequest put(String path) {
        return this.method(HttpMethod.put).path(path);
    }

    public HttpRequest delete(String path) {
        return this.method(HttpMethod.delete).path(path);
    }

    public HttpRequest bodys(Map<String, String> bodyParams) {
        bodyParams.forEach((key, value) -> this.body((String)key, (String)value));
        return this;
    }

    public HttpRequest body(String key, String value) {
        this.body.put(key, value);
        return this;
    }

    public HttpRequest querys(Map<String, ? extends Object> queryParams) {
        queryParams.forEach((key, value) -> this.query((String)key, value));
        return this;
    }

    public HttpRequest query(String key, Object value) {
        this.query.put(key, value.toString());
        return this;
    }

    public HttpRequest headers(Map<String, String> headerParams) {
        headerParams.forEach((key, value) -> this.header((String)key, (String)value));
        return this;
    }

    public HttpRequest header(String key, String value) {
        this.header.put(key, value);
        return this;
    }

    public void validateComplate() {
        AssertUtil.assertNoBadReq(this.method != null, Status.BadReq.illParam, "method\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertNoBadReq(this.path != null, Status.BadReq.illParam, "path\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertNoBadReq(this.endpoint != null, Status.BadReq.illParam, "endpoint\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
    }

    public String showUrl() {
        return MapParams.build().params(this.query).toUrlParams(this.endpoint + this.path);
    }

    public HttpRequestBase requestEntity() {
        this.validateComplate();
        switch (this.method) {
            case delete: {
                return new HttpDelete(this.showUrl());
            }
            case put: {
                return new HttpPut(this.showUrl());
            }
            case post: {
                return new HttpPost(this.showUrl());
            }
            case get: {
                return new HttpGet(this.showUrl());
            }
        }
        throw new UnsupportedException("\u4e0d\u652f\u6301\u7684method:%s", new Object[]{this.method});
    }

    public HttpResponse execute(Function<HttpRequest, Boolean> before) {
        this.validateComplate();
        Boolean right = before.apply(this);
        if (right.booleanValue()) {
            return HttpClientHelper.execute(this);
        }
        return HttpResponse.createAbort(this);
    }
}

