/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.log;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.asserts.AssertUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;

public class Event5WBuilder {
    private static final String[] skips = new String[]{"#:", "\\|"};
    private static final String eventVersion = "v31";
    private static final String todoVersion = "v31";
    private static final String eventPattern = String.format("\u9700\u8981\u5173\u6ce8\u4e8b\u4ef6%s#:{6}-event({5}),\u65f6\u95f4#:{0},\u5730\u70b9#:{1},\u8c01#:{2},\u4e8b\u60c5#:{3},\u65b9\u5f0f#:{7},\u539f\u56e0#:{4},\u7ed3\u679c#:{8},time#:{9},print#{10}", "v31");
    private static final String todoPattern = String.format("\u5f85\u5904\u7406\u5de5\u4f5c%s#:{6}-todo({5}),\u9700\u8981#:{2},\u5728#:{0},\u53bb#:{1},\u6267\u884c#:{3},\u65b9\u5f0f#:{7},\u539f\u56e0#:{4},\u7ed3\u679c#:{8},time#:{9},print#{10}", "v31");
    private String patternTemplate;
    private static final AsyncString emptyAsyncString = new AsyncString("\u65e0", new Object[0]);
    private Object type;
    private int level;
    private long createDate;
    private int printTime;
    private AsyncString when = emptyAsyncString;
    private AsyncString who = emptyAsyncString;
    private AsyncString what = emptyAsyncString;
    private AsyncString where = emptyAsyncString;
    private AsyncString why = emptyAsyncString;
    private AsyncString how = emptyAsyncString;
    private AsyncString result = emptyAsyncString;

    private Event5WBuilder returnThis() {
        return this;
    }

    public Event5WBuilder level(int level) {
        AssertUtil.assertSupport(level > 0 && level <= 5, "\u7ea7\u522b\u5fc5\u987b\u4e3a1,2,3,4,5\u4e2d\u7684\u4e00\u4e2a", new Object[0]);
        this.level = level;
        return this.returnThis();
    }

    public Event5WBuilder important() {
        return this.level(5);
    }

    public static Event5WBuilder todo(int level) {
        return Event5WBuilder.todo(level, "");
    }

    public static Event5WBuilder todo(int level, Object type) {
        Event5WBuilder temp = Event5WBuilder.build(type).level(level);
        temp.patternTemplate = todoPattern;
        return temp;
    }

    public static Event5WBuilder event(int level) {
        return Event5WBuilder.event(level, "");
    }

    public static Event5WBuilder event(int level, Object type) {
        Event5WBuilder temp = Event5WBuilder.build(type).level(level);
        temp.patternTemplate = eventPattern;
        return temp;
    }

    private static Event5WBuilder build(Object type) {
        AssertUtil.assertSupport(type != null, "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Event5WBuilder temp = new Event5WBuilder();
        temp.createDate = System.currentTimeMillis();
        temp.printTime = 0;
        temp.type = type;
        return temp;
    }

    public Event5WBuilder what(String string, Object ... params) {
        this.what = this.createAsync(string, params);
        return this.returnThis();
    }

    public Event5WBuilder where(String string, Object ... params) {
        this.where = this.createAsync(string, params);
        return this.returnThis();
    }

    public Event5WBuilder when(String string, Object ... params) {
        this.when = this.createAsync(string, params);
        return this.returnThis();
    }

    public Event5WBuilder who(String string, Object ... params) {
        this.who = this.createAsync(string, params);
        return this.returnThis();
    }

    public Event5WBuilder why(String string, Object ... params) {
        this.why = this.createAsync(string, params);
        return this.returnThis();
    }

    public Event5WBuilder how(String string, Object ... params) {
        this.how = this.createAsync(string, params);
        return this.returnThis();
    }

    public Event5WBuilder result(String string, Object ... params) {
        this.result = this.createAsync(string, params);
        return this.returnThis();
    }

    public String levelMsg() {
        return String.valueOf(this.level);
    }

    public String typeMsg() {
        return String.valueOf(this.type);
    }

    public Event5WBuilder oneLine() {
        return this;
    }

    public String create() {
        return this.create(false);
    }

    public String create(boolean oneLine) {
        String time = System.currentTimeMillis() - this.createDate + "ms";
        String msg = MessageFormat.format(this.patternTemplate, this.when.call(), this.where.call(), this.who.call(), this.what.call(), this.why.call(), this.levelMsg(), this.typeMsg(), this.how.call(), this.result.call(), time, ++this.printTime);
        return msg;
    }

    public String toString() {
        return this.create();
    }

    private AsyncString createAsync(String string, Object[] params) {
        return new AsyncString(string, params);
    }

    static class AsyncString {
        private String string;
        private Object[] params;

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }

        public AsyncString(String string, Object ... params) {
            AssertUtil.assertSupport(string != null, "\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a", new Object[0]);
            for (String skip : skips) {
                AssertUtil.assertSupport(string.length() == string.replaceAll(skip, "").length(), "\u63d0\u793a:[%s]\u8bed\u4e2d\u4e0d\u5141\u8bb8\u51fa\u73b0:[%s]", string, skip);
            }
            try {
                String.format(string, new String[params.length]);
            }
            catch (Throwable e) {
                throw new ServerException(e, String.format("\u51fa\u73b0\u4e25\u91cd\u95ee\u9898\u9700\u8981\u68c0\u67e5format:[%s],\u548c\u53c2\u6570\u8868\u4e2a\u6570:[%s]\u662f\u5426\u5339\u914d", string, params.length), new Object[0]);
            }
            this.string = string;
            this.params = params;
        }

        public String call() {
            try {
                String value = String.format(this.string, this.params);
                for (String skip : skips) {
                    value = value.replaceAll(skip, "");
                }
                return value;
            }
            catch (MissingFormatArgumentException e) {
                throw new BusyException((Throwable)e, "\u5b57\u7b26\u4e32\u683c\u5f0f\u5316\u5f02\u5e38 string:%s,params:%s", new Object[]{this.string, Arrays.toString(this.params)});
            }
        }
    }
}

