/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss.bean;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.oss.OssPicUtil;
import com.mini.framework.util.oss.OssWatermarkUtil;
import com.mini.framework.util.oss.bean.MapDirection;
import com.mini.framework.util.oss.bean.PicInfo;
import com.mini.framework.util.oss.bean.offset.GridOffsetWaterMarkNumber;
import com.mini.framework.util.oss.bean.offset.JiugePalaceOffsetWaterMarkType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OssImageProcessParams {
    private String action;
    private Map<String, String> params;
    private OssImageProcessParams nextsProcess;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public OssImageProcessParams paramIfVal(String key, Object value) {
        if (value != null) {
            this.param(key, String.valueOf(value));
        }
        return this;
    }

    public OssImageProcessParams param(String key, int value) {
        return this.param(key, String.valueOf(value));
    }

    public OssImageProcessParams param(String key) {
        return this.param(key, null);
    }

    public OssImageProcessParams paramXy(int x, int y) {
        return this.param("x", x).param("y", y);
    }

    public OssImageProcessParams paramXyIfVal(Integer x, Integer y) {
        return this.paramIfVal("x", x).paramIfVal("y", y);
    }

    public OssImageProcessParams paramWhIfVal(Integer w, Integer h) {
        return this.paramIfVal("w", w).paramIfVal("h", h);
    }

    public OssImageProcessParams paramWh(int w, int h) {
        return this.param("w", w).param("h", h);
    }

    public OssImageProcessParams paramBase64(String key, String value) {
        return this.param(key, OssWatermarkUtil.urlSafeBase64(value));
    }

    public OssImageProcessParams param(String key, String value) {
        AssertUtil.assertMethodRequire(key, "key");
        this.params.put(key, value);
        return this;
    }

    public OssImageProcessParams(String action, String key, String value) {
        this(action);
        this.param(key, value);
    }

    public OssImageProcessParams(String action, String key, int value) {
        this(action);
        this.param(key, value);
    }

    public OssImageProcessParams(String action, String key, String value, String key1, String value1) {
        this(action, key, value);
        this.param(key1, value1);
    }

    public OssImageProcessParams(String action, String key, int value, String key1, int value1) {
        this(action, key, value);
        this.param(key1, value1);
    }

    public static OssImageProcessParams create(String action) {
        return new OssImageProcessParams(action);
    }

    public OssImageProcessParams(String action) {
        AssertUtil.assertMethodRequire(action, "action");
        this.action = action;
        this.params = new LinkedHashMap<String, String>();
    }

    public String applyParams(String url) {
        AssertUtil.assertMethodRequire(url, "url");
        String split = url.contains("?") ? "&" : "?";
        String process = url.contains("x-oss-process=image") ? "" : split + "x-oss-process=image";
        url = url + process;
        url = url + "/" + this.action;
        url = url + this.params.entrySet().stream().map(e -> (String)e.getKey() + (e.getValue() == null ? "" : "_" + (String)e.getValue())).reduce("", (a, b) -> a + "," + b);
        if (this.nextsProcess != null) {
            url = this.nextsProcess.applyParams(url);
        }
        return url;
    }

    public static String applyMultiParams(String url, OssImageProcessParams ... opps) {
        return OssImageProcessParams.applyMultiParams(url, Arrays.asList(opps));
    }

    public static String applyMultiParams(String url, List<OssImageProcessParams> opps) {
        AssertUtil.assertMethodRequire(url, "url");
        for (int i = 0; i < opps.size(); ++i) {
            OssImageProcessParams opp = opps.get(i);
            url = opp.applyParams(url);
        }
        return url;
    }

    public static OssImageProcessParams linkMultiParams(List<OssImageProcessParams> opps) {
        AssertUtil.assertMethodRequire(opps, "opps");
        AssertUtil.assertSupport(opps.size() > 0, "opps\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        OssImageProcessParams first = (OssImageProcessParams)opps.stream().findFirst().get();
        if (opps.size() > 1) {
            first.andThenMultiParams(opps.get(1));
            OssImageProcessParams.linkMultiParams(opps.subList(1, opps.size()));
        }
        return first;
    }

    public OssImageProcessParams andThenMultiParams(OssImageProcessParams next) {
        this.nextsProcess = next;
        return this;
    }

    public static OssImageProcessParams linkMultiParams(OssImageProcessParams ... opps) {
        return OssImageProcessParams.linkMultiParams(Arrays.asList(opps));
    }

    public static OssImageProcessParams crossCutProcess(int offset, int limit, int width) {
        return OssImageProcessParams.crossCutProcess(true, offset, limit, width);
    }

    public static OssImageProcessParams crossCutProcess(boolean down, int offset, int limit, int width) {
        String pParam = down ? "nw" : "sw";
        return new OssImageProcessParams("crop", "g", pParam).param("x", 0).param("w", width).param("y", offset).param("h", limit);
    }

    public static OssImageProcessParams crossDownImageWatermarkProcess(String watermarkPath, int offset, int transparent) {
        String watermarkPathBase64 = OssWatermarkUtil.urlSafeBase64(watermarkPath);
        int covered = 100 - transparent;
        return new OssImageProcessParams("watermark", "image", watermarkPathBase64).param("g", "north").param("y", offset).param("t", covered);
    }

    public static OssImageProcessParams imageWatermark(MapDirection direction, String watermarkPath, Integer xoffset, Integer yoffset) {
        AssertUtil.assertMethodRequire((Object)direction, "direction");
        AssertUtil.assertMethodRequire(watermarkPath, "watermarkPath");
        String watermarkPathBase64 = OssWatermarkUtil.urlSafeBase64(watermarkPath);
        return new OssImageProcessParams("watermark", "image", watermarkPathBase64).param("g", direction.name()).param("x", xoffset).param("y", yoffset);
    }

    public static OssImageProcessParams imageNwWatermark(String watermarkPath, Integer xoffset, Integer yoffset) {
        return OssImageProcessParams.imageWatermark(MapDirection.nw, watermarkPath, xoffset, yoffset);
    }

    public static OssImageProcessParams textNwWatermark(String content, int xoffset, int yoffset, String color, int size, String type, int shadow, int rotate) {
        String contentBase64 = OssWatermarkUtil.urlSafeBase64(content);
        return new OssImageProcessParams("watermark", "text", contentBase64).param("g", "nw").param("x", xoffset).param("y", yoffset).param("type", OssWatermarkUtil.urlSafeBase64(type)).param("color", color).param("size", size).param("shadow", shadow).param("rotate", rotate);
    }

    public static String circleByRadius(String url, int radius) {
        return OssImageProcessParams.circleByRadius(radius).applyParams(url);
    }

    public static OssImageProcessParams circleByRadius(int radius) {
        OssImageProcessParams resize = new OssImageProcessParams("resize", "w", radius * 2, "h", radius * 2).param("m", "mfit");
        OssImageProcessParams circle = new OssImageProcessParams("circle").param("r", radius);
        OssImageProcessParams format = OssImageProcessParams.formatProcess("png");
        return OssImageProcessParams.linkMultiParams(resize, circle, format);
    }

    public static String circleByRoundedCorners(String url, int radius) {
        return OssImageProcessParams.circleByRoundedCorners(radius).applyParams(url);
    }

    public static OssImageProcessParams circleByRoundedCorners(int radius) {
        OssImageProcessParams resize = new OssImageProcessParams("resize", "w", radius * 2, "h", radius * 2).param("m", "fill");
        OssImageProcessParams crop = new OssImageProcessParams("crop", "w", radius * 2, "h", radius * 2).paramXy(0, 0).param("g", "center");
        OssImageProcessParams circle = new OssImageProcessParams("rounded-corners").param("r", radius);
        OssImageProcessParams format = OssImageProcessParams.formatProcess("png");
        return OssImageProcessParams.linkMultiParams(resize, crop, circle, format);
    }

    public static OssImageProcessParams roundedCornersProcess(int radius) {
        OssImageProcessParams rounded = new OssImageProcessParams("rounded-corners").param("r", radius);
        OssImageProcessParams format = OssImageProcessParams.formatProcess("png");
        return OssImageProcessParams.linkMultiParams(rounded, format);
    }

    public static OssImageProcessParams formatProcess(String format) {
        AssertUtil.assertMethodRequire(format, "format");
        return new OssImageProcessParams("format").param(format);
    }

    public static String formatSpecial(String format, String ossUrl) {
        return OssImageProcessParams.formatProcess(format).applyParams(ossUrl);
    }

    public static OssImageProcessParams formatWebpProcess() {
        return new OssImageProcessParams("format").param("webp");
    }

    public static String formatWebp(String ossUrl) {
        return OssImageProcessParams.formatWebpProcess().applyParams(ossUrl);
    }

    public static String watermarkAsGrid(String postUrl, String watermarkPath, int widthSize, int widthFrom, int widthTo, int heightSize, int heightFrom, int heightTo) {
        MapDirection defaultMapDirection;
        MapDirection direction = defaultMapDirection = MapDirection.se;
        AssertUtil.assertNoBadReq(widthFrom >= 0 && heightFrom >= 0, Status.BadReq.illParam, "\u6c34\u5370\u7684\u5bbd:[%s]\u9ad8:[%s]\u8d77\u70b9\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", widthFrom, heightFrom);
        AssertUtil.assertNoBadReq(widthFrom <= widthTo && heightFrom <= heightTo, Status.BadReq.illParam, "\u6c34\u5370\u7684\u5bbd\u8d77\u70b9:[%s]\u548c\u9ad8\u8d77\u70b9:[%s]\u4e0d\u80fd\u5927\u4e8e\u5bbd:[%s]\u6b62\u70b9\u548c\u9ad8:[%s]\u6b62\u70b9", widthFrom, heightFrom, widthTo, heightTo);
        AssertUtil.assertNoBadReq(widthSize >= widthTo && heightSize >= heightTo, Status.BadReq.illParam, "\u6c34\u5370\u7684\u5bbdsize:[%s]\u548c\u9ad8size:[%s]\u4e0d\u80fd\u5c0f\u4e8e\u5bbd:[%s]\u6b62\u70b9\u548c\u9ad8:[%s]\u6b62\u70b9", widthSize, heightSize, widthTo, heightTo);
        PicInfo info = OssPicUtil.findBaseInfo(postUrl);
        int posterWidth = info.getWidth();
        int posterHeight = info.getHeight();
        int xFrom = Math.round((float)posterWidth * (1.0f * (float)widthFrom / (float)widthSize));
        int yFrom = Math.round((float)posterHeight * (1.0f * (float)heightFrom / (float)heightSize));
        int xLimit = Math.round((float)posterWidth * (1.0f * (float)(widthTo - widthFrom) / (float)widthSize));
        int yLimit = Math.round((float)posterHeight * (1.0f * (float)(heightTo - heightFrom) / (float)heightSize));
        watermarkPath = new OssImageProcessParams("resize", "m", "lfit").paramWh(xLimit, yLimit).applyParams(watermarkPath);
        return OssImageProcessParams.imageWatermark(direction, watermarkPath, direction.countWeFromPoint(posterWidth, xFrom, xLimit).orElse(null), direction.countNsFromPoint(posterHeight, yFrom, yLimit).orElse(null)).applyParams(postUrl);
    }

    public static String watermarkJiuge(String postUrl, String watermarkPath, JiugePalaceOffsetWaterMarkType offset) {
        AssertUtil.assertMethodRequire((Object)offset, "offset");
        return OssImageProcessParams.watermarkAsGrid(postUrl, watermarkPath, 3, offset.getWeIndex(), offset.getWeIndex() + 1, 3, offset.getNsIndex(), offset.getNsIndex() + 1);
    }

    public static String watermarkAsGrid(String postUrl, String watermarkPath, GridOffsetWaterMarkNumber offset) {
        AssertUtil.assertMethodRequire(offset, "offset");
        return OssImageProcessParams.watermarkAsGrid(postUrl, watermarkPath, offset.getWs(), offset.getWf(), offset.getWt(), offset.getHs(), offset.getHf(), offset.getHt());
    }

    public static String watermarkAsGridPercent(String postUrl, String watermarkPath, int widthFrom, int widthTo, int heightFrom, int heightTo) {
        return OssImageProcessParams.watermarkAsGrid(postUrl, watermarkPath, 100, widthFrom, widthTo, 100, heightFrom, heightTo);
    }

    public static OssImageProcessParams resizeThenCenterCut(int width, int height, boolean reduceByLimit) {
        int max;
        int limit = 4096;
        if (reduceByLimit && (max = Math.max(width, height)) > limit) {
            width = Math.min(limit, width * limit / max);
            height = Math.min(limit, height * limit / max);
        }
        AssertUtil.assertNoBadReq(width <= limit, Status.BadReq.illParam, "\u963f\u91cc\u4e91\u56fe\u7247\u5904\u7406resize\u7ea6\u675fwidth(w):[%s]\u4e0d\u80fd\u5927\u4e8e:[%s]", width, limit);
        AssertUtil.assertNoBadReq(height <= limit, Status.BadReq.illParam, "\u963f\u91cc\u4e91\u56fe\u7247\u5904\u7406resize\u7ea6\u675fheight(h):[%s]\u4e0d\u80fd\u5927\u4e8e:[%s]", height, limit);
        return OssImageProcessParams.create("resize").param("m", "fill").paramWh(width, height);
    }

    public static OssImageProcessParams resizeThenCenterCut(int width, int height) {
        return OssImageProcessParams.resizeThenCenterCut(width, height, false);
    }
}

