/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.params;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.BeanUtil;
import com.mini.framework.util.optional.OptionalDateRange;
import com.mini.framework.util.params.CompareType;
import com.mini.framework.util.string.StringUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapParams
extends LinkedHashMap<String, Object> {
    private Logger logger = LogManager.getLogger(MapParams.class);
    private static final long serialVersionUID = 5748967435422272687L;
    protected static String USER_ID = "userId";
    protected static String ID = "id";
    protected static String CREATE_DATE = "createDate";
    protected Map<String, Type> multiFilterFieldType = new HashMap<String, Type>();
    protected LinkedHashMap<String, String> inFieldsKey = this.getInFieldsKey(10);
    private int nullValueCount = 0;
    private int orderByIndex = 0;
    private int betweenIndex = 0;
    private Map<String, String> orderByParams = new LinkedHashMap<String, String>();

    public static MapParams build(String paramKey, Object paramValue) {
        return MapParams.build().param(paramKey, paramValue);
    }

    private LinkedHashMap<String, String> getInFieldsKey(int max) {
        LinkedHashMap<String, String> inFields = new LinkedHashMap<String, String>();
        for (int i = 1; i <= max; ++i) {
            inFields.put("inField" + i, "inValues" + i);
        }
        return inFields;
    }

    public static MapParams buildUserId(Object userId) {
        return MapParams.build().param(USER_ID, userId);
    }

    public static MapParams buildId(Object id) {
        return MapParams.build().param(ID, id);
    }

    public static MapParams build() {
        return new MapParams();
    }

    @Deprecated
    public <T> MapParams paramIfAbsent(String paramKey, Optional<T> paramValueOptional) {
        return this.paramIfPresent(paramKey, paramValueOptional);
    }

    public <T> MapParams paramIfPresent(String paramKey, Optional<T> paramValueOptional) {
        AssertUtil.assertMethodRequire(paramValueOptional, "paramValueOptional");
        return this.paramIfAbsent(paramKey, (Object)paramValueOptional.orElse(null));
    }

    @Deprecated
    public MapParams paramIfAbsent(String paramKey, Object paramValue) {
        return this.paramIfPresent(paramKey, paramValue);
    }

    public MapParams paramIfPresent(String paramKey, Object paramValue) {
        if (paramValue != null) {
            this.param(paramKey, paramValue);
        }
        return this;
    }

    public MapParams param(String paramKey, Object paramValue) {
        AssertUtil.simpleAssertByStatus(paramKey != null && paramKey.length() > 0, Status.Busy.fatalBug, "\u4e0d\u80fd\u4f20\u4e00\u4e2aparamKey\u4e3a\u7a7a\u7684\u53c2\u6570val:%s", paramValue);
        AssertUtil.assertMethodRequire(paramValue, "paramValue");
        this.put(paramKey, paramValue);
        return this;
    }

    public MapParams params(Map<String, ?> map) {
        map.forEach((key, value) -> this.paramIfAbsent((String)key, value));
        return this;
    }

    public MapParams paramsFromBean(Object bean) {
        AssertUtil.assertMethodRequire(bean, "bean");
        Map<String, Object> stringKeyValue = BeanUtil.beanToMap(bean);
        return this.params(stringKeyValue);
    }

    public MapParams paramAllowNull(String paramKey, Object paramValue) {
        if (paramValue != null) {
            return this.param(paramKey, paramValue);
        }
        return this.paramNull(paramKey);
    }

    public MapParams paramNull(String paramKey) {
        AssertUtil.simpleAssertByStatus(paramKey != null && paramKey.length() > 0, Status.Busy.fatalBug, "\u4e0d\u80fd\u4f20\u4e00\u4e2aparamKey\u4e3a\u7a7a\u7684\u53c2\u6570", new Object[0]);
        this.put(paramKey, null);
        return this;
    }

    public MapParams paramUserId(Object paramValue) {
        return this.param(USER_ID, paramValue);
    }

    public MapParams descBy(String key) {
        return this.orderBy(key, true);
    }

    public MapParams ascBy(String key) {
        return this.orderBy(key, false);
    }

    public MapParams orderBy(String key, boolean desc) {
        AssertUtil.assertSupport(!this.orderByParams.containsKey(key), "\u6392\u5e8fkey:[%s]\u4e0d\u5141\u8bb8\u4f7f\u7528\u591a\u6b21,params:[%s]", key, this.orderByParams);
        String suffix = this.orderByIndex == 0 ? "" : String.valueOf(this.orderByIndex);
        ++this.orderByIndex;
        String orderByKey = "orderBy" + suffix;
        String orderByDescAscKey = "descAsc" + suffix;
        this.param(orderByKey, key);
        this.param(orderByDescAscKey, desc ? "desc" : "asc");
        this.orderByParams.put(key, desc ? "desc" : "asc");
        AssertUtil.assertSupport(this.orderByParams.size() <= 10, "\u76ee\u524d\u53ea\u652f\u630110\u4e2a\u6392\u5e8fkey,sortParams:%s", this.orderByParams);
        return this;
    }

    public MapParams limit(int offset, int length) {
        this.param("limit", "limit");
        this.param("offset", offset);
        this.param("length", length);
        return this;
    }

    @Deprecated
    public MapParams inField(String field, Set<? extends Object> inValues) {
        AssertUtil.assertSupport(this.get("inField") == null, "inField\u53c2\u6570:[%s]\u4e0d\u652f\u6301\u591a\u6b21\u4f7f\u7528", field);
        this.param("inField", field);
        this.param("inValues", inValues);
        return this;
    }

    @Deprecated
    public <T> MapParams addInFieldIfAbsent(String field, Optional<Set<T>> inValuesOptional) {
        return this.addInFieldIfPresent(field, inValuesOptional);
    }

    public <T> MapParams addInFieldIfPresent(String field, Optional<Set<T>> inValuesOptional) {
        return this.addInFieldIfPresent(field, (Set<? extends Object>)inValuesOptional.orElse(null));
    }

    @Deprecated
    public MapParams addInFieldIfAbsent(String field, Set<? extends Object> inValues) {
        return this.addInFieldIfPresent(field, inValues);
    }

    public MapParams addInFieldIfPresent(String field, Set<? extends Object> inValues) {
        if (inValues != null && inValues.size() > 0) {
            this.addInField(field, inValues);
        }
        return this;
    }

    @Deprecated
    public MapParams addInFieldIfAbsent(String field, Set<? extends Object> inValues, boolean notIn) {
        return this.addInFieldIfPresent(field, inValues, notIn);
    }

    public MapParams addInFieldIfPresent(String field, Set<? extends Object> inValues, boolean notIn) {
        if (inValues != null && inValues.size() > 0) {
            this.addInField(field, inValues, notIn);
        }
        return this;
    }

    @Deprecated
    public MapParams addNotInFieldIfAbsent(String field, Set<? extends Object> inValues) {
        return this.addNotInFieldIfPresent(field, inValues);
    }

    public MapParams addNotInFieldIfPresent(String field, Set<? extends Object> inValues) {
        if (inValues != null && inValues.size() > 0) {
            this.addInField(field, inValues, true);
        }
        return this;
    }

    public MapParams addNotInField(String field, Set<? extends Object> inValues) {
        return this.addInField(field, inValues, true);
    }

    public MapParams addInField(String field, Set<? extends Object> inValues) {
        return this.addInField(field, inValues, false);
    }

    public MapParams addInField(String field, Set<? extends Object> inValues, boolean notIn) {
        AssertUtil.assertMethodRequire(inValues, "inValues");
        AssertUtil.assertSupport(inValues.size() > 0, "\u5c5e\u6027:[%s]\u7684in\u6761\u4ef6\u6570\u4e0d\u80fd\u4e3a0", field);
        AssertUtil.assertSupport(inValues.stream().filter(Objects::isNull).count() == 0L, "\u5c5e\u6027:[%s]\u7684in\u6761\u4ef6\u4e0d\u80fd\u6709\u7a7a\u6307\u9488inValues:%s", field, inValues);
        LinkedHashMap<String, String> inFieldsKey = new LinkedHashMap<String, String>(this.inFieldsKey);
        int index = 0;
        for (Map.Entry<String, String> entry : inFieldsKey.entrySet()) {
            boolean haveField;
            boolean bl = haveField = this.get(entry.getKey()) != null;
            if (haveField) continue;
            this.paramIfPresent("notInField" + (index++ + 1), notIn);
            this.param(entry.getKey(), field);
            this.param(entry.getValue(), inValues);
            return this;
        }
        throw new UnsupportedException("\u6700\u591a\u53ea\u652f\u6301%s\u4e2ainField", new Object[]{inFieldsKey.size()});
    }

    public MapParams dateRange(String field, Date fromDate, Date toDate) {
        return this.dateAfter(field, fromDate).dateBefore(field, toDate);
    }

    public MapParams dateRangeIfPresent(String field, Optional<Date> fromDateOptional, Optional<Date> toDateOptional) {
        return this.dateBeforeIfPresent(field, toDateOptional).dateAfterIfPresent(field, fromDateOptional);
    }

    public MapParams dateRangeIfPresent(String field, OptionalDateRange dateRangeOptional) {
        AssertUtil.assertMethodRequire(dateRangeOptional, "dateRangeOptional");
        AssertUtil.assertMethodRequire(field, "field");
        return this.dateRangeIfPresent(field, dateRangeOptional.outFromDate(), dateRangeOptional.outToDate());
    }

    public MapParams dateRangeRequirePresent(String field, OptionalDateRange dateRangeOptional) {
        AssertUtil.assertMethodRequire(dateRangeOptional, "dateRangeOptional");
        return this.dateRange(field, dateRangeOptional.outFromDate().orElseThrow(() -> new UnsupportedException("fromDate\u4e0d\u80fd\u4e3a\u7a7a", new Object[0])), dateRangeOptional.outToDate().orElseThrow(() -> new UnsupportedException("toDate\u4e0d\u80fd\u4e3a\u7a7a", new Object[0])));
    }

    public MapParams timeAfter(TimeUnit timeUnit, int time) {
        Date fromDate = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        return this.dateAfter(fromDate);
    }

    @Deprecated
    public MapParams dateAfter(Date fromDate) {
        AssertUtil.simpleAssertByStatus(fromDate != null, Status.Busy.bug, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        this.param("dateRange", "dateRange");
        this.param("rangeFromDate", fromDate);
        return this;
    }

    public MapParams dateAfterIfPresent(String field, Optional<Date> fromDateOptional) {
        AssertUtil.assertMethodRequire(fromDateOptional, "fromDateOptional");
        fromDateOptional.ifPresent(fromDate -> this.dateAfter(field, (Date)fromDate));
        return this;
    }

    public MapParams dateBeforeIfPresent(String field, Optional<Date> toDateOptional) {
        AssertUtil.assertMethodRequire(toDateOptional, "toDateOptional");
        toDateOptional.ifPresent(toDate -> this.dateBefore(field, (Date)toDate));
        return this;
    }

    public MapParams dateAfter(String field, Date fromDate) {
        AssertUtil.assertMethodRequire(field, "field");
        AssertUtil.assertMethodRequire(fromDate, "fromDate");
        AssertUtil.assertSupport(this.get("rangeFromField") == null, "\u4e0d\u5141\u8bb8\u4f7f\u7528\u591a\u4e2a\u65f6\u95f4\u8303\u56f4\u53c2\u6570", new Object[0]);
        this.param("rangeFromDate", fromDate);
        this.param("rangeFromField", field);
        return this;
    }

    @Deprecated
    public MapParams numberBetweenIfAbsent(String field, Integer from, Integer to) {
        return this.numberBetweenIfPresent(field, from, to);
    }

    public MapParams numberBetweenIfPresent(String field, Integer from, Integer to) {
        return this.numberBetweenIfPresent(field, Optional.ofNullable(from), Optional.ofNullable(to));
    }

    public MapParams numberBetweenIfPresent(String field, Optional<Integer> fromOptional, Optional<Integer> toOptional) {
        AssertUtil.assertMethodRequire(fromOptional, "fromOptional");
        AssertUtil.assertMethodRequire(toOptional, "toOptional");
        if (fromOptional.isPresent() || toOptional.isPresent()) {
            return this.numberBetween(field, fromOptional.orElse(null), toOptional.orElse(null));
        }
        return this;
    }

    public MapParams numberBetween(String field, Integer from, Integer to) {
        AssertUtil.assertMethodRequire(field, "field");
        ++this.betweenIndex;
        AssertUtil.assertSupport(from != null || to != null, "from\u548cto\u4e0d\u80fd\u90fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertSupport(this.betweenIndex <= 4, "numberBetween\u65b9\u5f0f\u6700\u591a\u53ea\u652f\u63013\u4e2a   param:%s", this);
        String suffix = String.valueOf(this.betweenIndex);
        if (from != null) {
            this.param("betweenFromField" + suffix, field);
            this.param("betweenFromNumber" + suffix, from);
        }
        if (to != null) {
            this.param("betweenToField" + suffix, field);
            this.param("betweenToNumber" + suffix, to);
        }
        return this;
    }

    public MapParams dateBefore(String field, Date toDate) {
        AssertUtil.assertMethodRequire(field, "field");
        AssertUtil.assertMethodRequire(toDate, "toDate");
        AssertUtil.simpleAssertByStatus(toDate != null, Status.Busy.bug, "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertSupport(this.get("rangeToField") == null, "\u4e0d\u5141\u8bb8\u4f7f\u7528\u591a\u4e2a\u65f6\u95f4\u8303\u56f4\u53c2\u6570", new Object[0]);
        this.param("rangeToDate", toDate);
        this.param("rangeToField", field);
        return this;
    }

    @Deprecated
    public MapParams setAttrNull(String ... fields) {
        return this.addSetAttrNull(fields);
    }

    public MapParams addSetAttrNull(String ... fields) {
        return this.addSetAttrNull(Stream.of(fields).collect(Collectors.toSet()));
    }

    public MapParams addSetAttrNull(Set<String> fields) {
        AssertUtil.assertSupport(fields.size() > 0, "\u4e0d\u80fd\u4e3a\u4f20\u53c2\u6570", new Object[0]);
        AssertUtil.assertSupport(fields.size() < 5, "\u76ee\u524d\u6700\u591a\u652f\u63014\u4e2a\u53c2\u6570,\u5f53\u524d\u53c2\u6570\u4e3a:%s", fields);
        int i = 1;
        for (String field : fields) {
            this.param("setNullAttr" + i++, field);
        }
        return this;
    }

    public MapParams andAttrNull(String ... fields) {
        AssertUtil.assertSupport(fields.length > 0, "\u4e0d\u80fd\u4e3a\u4f20\u53c2\u6570", new Object[0]);
        AssertUtil.assertSupport(fields.length <= 7, "\u76ee\u524d\u6700\u591a\u652f\u63017\u4e2a\u53c2\u6570,\u5f53\u524d\u53c2\u6570\u4e3a:%s", Arrays.toString(fields));
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            this.param("andNullAttr" + (i + 1), field);
        }
        return this;
    }

    public MapParams andAttrIfNull(boolean ifNull, String ... fields) {
        if (ifNull) {
            return this.andAttrNull(fields);
        }
        return this.andAttrNotNull(fields);
    }

    public MapParams andAttrNotNull(String ... fields) {
        AssertUtil.assertSupport(fields.length > 0, "\u4e0d\u80fd\u4e3a\u4f20\u53c2\u6570", new Object[0]);
        AssertUtil.assertSupport(fields.length <= 7, "\u76ee\u524d\u6700\u591a\u652f\u63017\u4e2a\u53c2\u6570,\u5f53\u524d\u53c2\u6570\u4e3a:%s", Arrays.toString(fields));
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            this.param("andNotNullAttr" + (i + 1), field);
        }
        return this;
    }

    public MapParams atomAdd(String field, int add, int limit) {
        return this.multiField("atomAdd", "atomAddField", "atomAddNum", field, add, limit);
    }

    @Deprecated
    public MapParams atomAddIfAbsent(String field, Integer add, int limit) {
        return this.atomAddIfPresent(field, add, limit);
    }

    public MapParams atomAddIfPresent(String field, Integer add, int limit) {
        if (add != null) {
            this.multiField("atomAdd", "atomAddField", "atomAddNum", field, add, limit);
        }
        return this;
    }

    private MapParams multiField(String type, String fieldPrefix, String valuePrefix, String field, Object value, int limit) {
        this.param(type, type);
        for (int i = 1; i <= limit; ++i) {
            String key = fieldPrefix + i;
            Object val = this.get(key);
            if (val != null) continue;
            this.param(key, field);
            this.param(valuePrefix + i, value);
            return this;
        }
        throw new UnsupportedException("%s\u7c7b\u578b\u7684\u4f7f\u7528\u4e0a\u9650\u4e3a%s", new Object[]{type, limit});
    }

    public MapParams compare(String field, Object value, CompareType compare) {
        AssertUtil.assertMethodRequire(field, "field");
        AssertUtil.assertMethodRequire(value, "value");
        AssertUtil.assertMethodRequire((Object)compare, "compare");
        this.param("compare", true);
        AssertUtil.assertSupport(this.get(compare.getName()) == null, "%s\u4e0d\u80fd\u88ab\u4f7f\u7528\u4e24\u6b21", compare.getName());
        this.param(compare.getName(), true);
        this.param(compare.getFieldKey(), field);
        this.param(compare.getValueKey(), value);
        return this;
    }

    public MapParams multiFilterString(String ... fields) {
        AssertUtil.assertSupport(this.multiFilterFieldType != null, "\u5339\u914d\u540e\u4e0d\u80fd\u518d\u7533\u660e", new Object[0]);
        AssertUtil.assertSupport(fields.length > 0, "declareStringType\u67e5\u8be2\u81f3\u5c11\u8981\u4f20\u4e00\u4e2a\u53c2\u6570", new Object[0]);
        for (String field : fields) {
            this.multiFilterFieldType.put(field, (Type)((Object)String.class));
        }
        return this;
    }

    public MapParams multiFilterNumeric(String ... fields) {
        AssertUtil.assertSupport(this.multiFilterFieldType != null, "\u5339\u914d\u540e\u4e0d\u80fd\u518d\u7533\u660e", new Object[0]);
        AssertUtil.assertSupport(fields.length > 0, "declareIntType\u67e5\u8be2\u81f3\u5c11\u8981\u4f20\u4e00\u4e2a\u53c2\u6570", new Object[0]);
        for (String field : fields) {
            this.multiFilterFieldType.put(field, (Type)((Object)Integer.class));
        }
        return this;
    }

    public String[] splitKeyword(String keyword) {
        keyword = keyword.replaceAll("[^a-zA-Z0-9\u4e00-\u9fa5]", " ");
        Object[] keys = StringUtils.split((String)keyword, null);
        AssertUtil.validateParams((keys = Arrays.asList(keys).stream().filter(key -> key != null && key.length() > 0).distinct().collect(Collectors.toList()).toArray(keys)).length < 30, "\u89e3\u6790\u51fa\u6765\u7684\u641c\u7d22\u6761\u4ef6\u8fc7\u4e8e\u590d\u6742\u539f\u6761\u4ef6:[%s]\u89e3\u6790\u540e\u6761\u4ef6\u4e3a%s", keyword, Arrays.toString(keys));
        return keys;
    }

    public MapParams multiFilterMatch(String ... keywords) {
        ArrayList<String> orSqls = new ArrayList<String>();
        for (String keyword : keywords) {
            Optional<String> orSqlOptional = this.multiFilterOrSqlMatch(keyword, this.multiFilterFieldType);
            if (!orSqlOptional.isPresent()) continue;
            orSqls.add(orSqlOptional.get());
            String debugMsg = String.format("\u6839\u636e\u5173\u952e\u5b57\u7b26\u4e32:[%s]\u67e5\u8be2\u5b57\u6bb5:%s,\u5f97\u5230sql\u7247\u6bb5:[%s]", keyword, this.multiFilterFieldType, orSqlOptional.get());
            this.logger.debug(debugMsg);
        }
        if (orSqls.size() > 0) {
            this.param("keywordMultiLike", StringUtils.join(orSqls, (String)" and "));
        }
        this.multiFilterFieldType = null;
        return this;
    }

    public Optional<String> multiFilterOrSqlMatch(String keyword, Map<String, Type> multiFilterFieldType) {
        String[] keys;
        AssertUtil.assertSupport(multiFilterFieldType.size() > 0, "\u5fc5\u987b\u5148\u7533\u660e\u624d\u80fd\u5339\u914d", new Object[0]);
        AssertUtil.assertSupport(keyword != null && keyword.length() != 0, "multiFilterMatch\u67e5\u8be2\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.assertSupport(keyword.trim().length() == keyword.length(), "multiFilterMatch\u67e5\u8be2\u5173\u952e\u5b57\u524d\u540e\u4e0d\u80fd\u6709\u65e0\u6548\u5b57\u7b26", new Object[0]);
        ArrayList<String> orSqls = new ArrayList<String>();
        for (String key : keys = this.splitKeyword(keyword)) {
            for (String field : multiFilterFieldType.keySet()) {
                Type fieldType = multiFilterFieldType.get(field);
                AssertUtil.assertSupport(fieldType != null, "field:[%s]\u6ca1\u6709\u58f0\u660e\u6570\u636e\u7c7b\u578b", field);
                String sql = null;
                if (Integer.class.equals((Object)fieldType)) {
                    if (!StringUtils.isNumeric((CharSequence)key)) continue;
                    sql = field + " = " + key;
                    orSqls.add(sql);
                    continue;
                }
                if (String.class.equals((Object)fieldType)) {
                    sql = field + " like '%" + key + "%'";
                    orSqls.add(sql);
                    continue;
                }
                throw new UnsupportedException("\u4e0d\u652f\u6301\u7684\u8fc7\u6ee4\u6570\u636e\u7c7b\u578b%s", new Object[]{fieldType});
            }
        }
        String orSqlString = StringUtils.join(orSqls, (String)" or ");
        if (orSqlString.length() == 0) {
            return Optional.empty();
        }
        orSqlString = " ( " + orSqlString + " ) ";
        return Optional.of(orSqlString);
    }

    public LinkedHashMap<String, String> toStringMap() {
        return this.toStringMap(key -> "null");
    }

    public LinkedHashMap<String, String> toStringMap(Function<String, String> defaultValueFunction) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String stringValue = Optional.ofNullable(value).map(Object::toString).orElseGet(() -> (String)defaultValueFunction.apply(key));
            map.put(key, stringValue);
        }
        return map;
    }

    public int getNullValueCount() {
        return this.nullValueCount;
    }

    public <T> MapParams runRequire(T require, Consumer<MapParams> consumer) {
        return this.runIf(require != null, consumer);
    }

    public <T> MapParams ifPresent(Optional<T> optional, BiConsumer<MapParams, T> biConsumer) {
        optional.ifPresent(v -> biConsumer.accept(this, v));
        return this;
    }

    public MapParams run(Consumer<MapParams> consumer) {
        return this.runIf(true, consumer);
    }

    public MapParams runIf(boolean explain, Consumer<MapParams> consumer) {
        if (explain) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public String toString() {
        return "nullValueCount:" + this.nullValueCount + ",map:" + super.toString();
    }

    public String toUrlParams(String url) {
        AssertUtil.assertMethodRequire(url, "url");
        String split = url.contains("?") ? "&" : "?";
        return url + split + this.toUrlParams();
    }

    public Function<String, String> asMapFunction() {
        LinkedHashMap<String, String> smap = this.toStringMap();
        return key -> (String)smap.get(key);
    }

    public String toParamSplit(String split, String itemSplit) {
        return this.toStringMap().entrySet().stream().map(MapParams.toParamSplitFunction(split)).collect(Collectors.joining(itemSplit));
    }

    public static Function<Map.Entry<String, String>, String> toParamSplitFunction(String split) {
        return entry -> MapParams.toParamSplit(entry, split);
    }

    public static String toParamSplit(Map.Entry<String, String> entry, String split) {
        return entry.getKey() + split + entry.getValue();
    }

    public String toUrlParams() {
        return this.toUrlParams(Object::toString, Function.identity());
    }

    public String toUrlParamsEncodeValue() {
        return this.toUrlParams(Object::toString, StringUtil::urlEncode);
    }

    public String toUrlParams(Function<Object, String> valueToString, Function<String, String> urlEncodeHandle) {
        MapParams other = MapParams.build().params(this);
        other.forEach((key, value) -> {
            if (value == null) {
                other.paramNull("");
            } else {
                other.param((String)key, valueToString.andThen(urlEncodeHandle).apply(value));
            }
        });
        return other.toParamSplit("=", "&");
    }

    public MapParams sortedByKey() {
        MapParams other = MapParams.build().params(this);
        this.clear();
        other.keySet().stream().sorted(Comparator.comparing(String::valueOf)).forEach((? super T key) -> this.paramIfPresent((String)key, other.get(key)));
        return this;
    }

    public String toSortedUrlParams() {
        return MapParams.build().params(this).sortedByKey().toUrlParams();
    }

    public <R> R apply(Function<MapParams, R> executor) {
        return executor.apply(this);
    }
}

