/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.relation;

import com.mini.framework.util.relation.Cascadable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface LinkTreeCursor<T> {
    public void scan(Cascadable<T> var1);

    public LinkTreeCursor<T> moreCursor();

    public LinkTreeCursor<T> popMoreCursor();

    public void forSummary(LinkTreeCursor<T> var1);

    public static <T> void scanTree(LinkTreeCursor<T> linkTreeCursor, Collection<? extends Cascadable<T>> cascadables) {
        for (Cascadable<T> cascadable : cascadables) {
            List<T> subCascadables = cascadable.showSonNodes();
            if (subCascadables != null && subCascadables.size() > 0) {
                LinkTreeCursor<T> subLinkTreeCursor = linkTreeCursor.moreCursor();
                LinkTreeCursor.scanTree(subLinkTreeCursor, subCascadables);
                linkTreeCursor.forSummary(subLinkTreeCursor);
            }
            linkTreeCursor.scan(cascadable);
        }
    }

    public static <T> List<LinkTreeCursor<T>> toList(LinkTreeCursor<T> corsorTree) {
        ArrayList<LinkTreeCursor<T>> corsors = new ArrayList<LinkTreeCursor<T>>();
        corsors.add(corsorTree);
        LinkTreeCursor<T> currCorsor = corsorTree;
        LinkTreeCursor<T> next = null;
        while ((next = currCorsor.popMoreCursor()) != null) {
            corsors.add(next);
            currCorsor = next;
        }
        return corsors;
    }
}

