/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.protocol.process;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ForkQuerySpot<R> {
    private Date readyDate;
    private Date beginDate;
    private Date endDate;
    private Long executeTime;
    private Long waitTime;
    private Long fullyTime;
    private Object processParams;
    private Future<R> asyncExecutor;
    private R syncResult;

    private void countTimeConsume() {
        AssertUtil.assertMethodRequire(this.beginDate, "beginDate");
        AssertUtil.assertMethodRequire(this.endDate, "endDate");
        this.executeTime = this.endDate.getTime() - this.beginDate.getTime();
        this.waitTime = this.beginDate.getTime() - this.readyDate.getTime();
        this.fullyTime = this.executeTime + this.waitTime;
    }

    public static <R> ForkQuerySpot<R> createThenAsyncBegin(Supplier<R> task, Executor executor, Object processParams) {
        AssertUtil.assertMethodRequire(executor, "executor");
        AssertUtil.assertMethodRequire(task, "task");
        ForkQuerySpot instance = new ForkQuerySpot();
        instance.readyDate = new Date();
        instance.asyncExecutor = CompletableFuture.supplyAsync(() -> {
            instance.processParams = processParams;
            instance.beginDate = new Date();
            Object result = task.get();
            instance.endDate = new Date();
            instance.countTimeConsume();
            return result;
        }, executor);
        return instance;
    }

    public R fillThenSyncBegin(Supplier<R> task) {
        AssertUtil.assertMethodRequire(task, "task");
        if (this.syncResult == null) {
            this.beginDate = new Date();
            this.readyDate = new Date(this.beginDate.getTime());
            this.syncResult = task.get();
            this.asyncExecutor = CompletableFuture.completedFuture(this.syncResult);
            this.endDate = new Date();
            this.countTimeConsume();
        }
        return this.syncResult;
    }

    public Date getReadyDate() {
        return this.readyDate;
    }

    public void setReadyDate(Date readyDate) {
        this.readyDate = readyDate;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(Long executeTime) {
        this.executeTime = executeTime;
    }

    public Long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(Long waitTime) {
        this.waitTime = waitTime;
    }

    public Long getFullyTime() {
        return this.fullyTime;
    }

    public void setFullyTime(Long fullyTime) {
        this.fullyTime = fullyTime;
    }

    public Object getProcessParams() {
        return this.processParams;
    }

    public void setProcessParams(Object processParams) {
        this.processParams = processParams;
    }

    public Future<R> showAsyncExecutor() {
        return this.asyncExecutor;
    }

    public Optional<R> showSyncResult() {
        return Optional.ofNullable(this.syncResult);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

