/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.ranking;

import com.mini.framework.util.report.statistics.protocol.KeyStringValueStorage;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.ranking.RankingDimensionFeature;
import com.mini.framework.util.report.statistics.ranking.bean.RankingElementSummationAmount;
import com.mini.framework.util.report.statistics.ranking.bean.StatisticsRankingTable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface StringStoreRankingDimensionFeature<P extends StatisticsSerializeParams, A extends RankingElementSummationAmount<A>>
extends RankingDimensionFeature<P, A>,
KeyStringValueStorage {
    @Override
    default public void saveRankingTableToCache(String rankingKey, StatisticsRankingTable<A> ranking) {
        String rankingString = ranking.serialize(this.utilFullyEmptyElement());
        this.coverSaveStringCache(rankingKey, rankingString);
    }

    @Override
    default public Optional<StatisticsRankingTable<A>> queryCacheRankingTable(String rankingKey, Optional<Integer> headOptional) {
        return this.queryStringCacheByKey(rankingKey).map(string -> this.stringMapperRankingItemScoreList((String)string, headOptional));
    }

    default public StatisticsRankingTable<A> stringMapperRankingItemScoreList(String string, Optional<Integer> headOptional) {
        StatisticsRankingTable ranking = StatisticsRankingTable.deserialize(string, this.utilFullyEmptyElement());
        return ranking.retainLimitHead(headOptional);
    }

    @Override
    default public Map<String, StatisticsRankingTable<A>> queryBatchCacheRankingTable(Map<String, Optional<Integer>> keyHeadOptionalMapper) {
        HashMap<String, StatisticsRankingTable<A>> mapper = new HashMap<String, StatisticsRankingTable<A>>();
        Map<String, String> keyStringMapper = this.queryBatchStringCacheByKeys(keyHeadOptionalMapper.keySet());
        keyHeadOptionalMapper.forEach((rankingKey, headOptional) -> {
            Optional stringCacheOptional = Optional.ofNullable(keyStringMapper.get(rankingKey));
            stringCacheOptional.ifPresent(stringCache -> mapper.put((String)stringCache, this.stringMapperRankingItemScoreList((String)stringCache, (Optional<Integer>)headOptional)));
        });
        return mapper;
    }

    @Override
    default public StatisticsRankingTable<A> accumulateRankingTableToCache(String rankingKey, StatisticsRankingTable<A> incrementRanking, boolean coverOrigin) {
        StatisticsRankingTable originRanking = this.queryCacheRankingTable(rankingKey, Optional.empty()).orElse(StatisticsRankingTable.createEmpty());
        StatisticsRankingTable<RankingElementSummationAmount> allRinking = StatisticsRankingTable.accumulateRankings(this::createEmptyElement, originRanking, incrementRanking);
        if (coverOrigin) {
            this.coverSaveStringCache(rankingKey, allRinking.serialize(this.utilFullyEmptyElement()));
        }
        return allRinking;
    }
}

