/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.summation.bean.array;

import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.SummationElementAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class MultiParamsNativeRegionSummationArray<P extends StatisticsSerializeParams>
implements OneStatisticsResult {
    private StatisticsResultMeta resultMeta;
    private ForkQueryProcess process;
    private SummationElementAmount allSummation = SummationElementAmount.createZeroEmpty();
    private List<StatisticsEntry<P>> elements = new ArrayList<StatisticsEntry<P>>();

    public MultiParamsNativeRegionSummationArray<P> add(StatisticsEntry<P> entry) {
        this.elements.add(entry);
        this.statisticsAllElement();
        return this;
    }

    public MultiParamsNativeRegionSummationArray<P> add(P params, NativeRegionSummationElementAmount summation) {
        return this.add(new StatisticsEntry<P>(params, summation));
    }

    public MultiParamsNativeRegionSummationArray<P> statisticsAllElement() {
        this.allSummation = this.elements.stream().map(StatisticsEntry::getSummation).map(sa -> sa).reduce(SummationElementAmount.createZeroEmpty(), SummationElementAmount::mergeAmount);
        return this;
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(this.resultMeta);
    }

    public MultiParamsNativeRegionSummationArray<P> sortDescBySum(boolean thenCount) {
        Collections.sort(this.elements, Comparator.comparing(StatisticsEntry::getSummation, SummationElementAmount.sorterBySum(thenCount)));
        Collections.reverse(this.elements);
        return this;
    }

    public MultiParamsNativeRegionSummationArray<P> sortDescByCount(boolean thenSum) {
        Collections.sort(this.elements, Comparator.comparing(StatisticsEntry::getSummation, SummationElementAmount.sorterByCount(thenSum)));
        Collections.reverse(this.elements);
        return this;
    }

    public SummationElementAmount getAllSummation() {
        return this.allSummation;
    }

    public void setAllSummation(SummationElementAmount allSummation) {
        this.allSummation = allSummation;
    }

    public List<StatisticsEntry<P>> getElements() {
        return this.elements;
    }

    public void setElements(List<StatisticsEntry<P>> elements) {
        this.elements = elements;
    }

    public StatisticsResultMeta getResultMeta() {
        return this.resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return this.process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public void clearRedundancyFields() {
        this.elements.forEach(StatisticsEntry::clearRedundancyFields);
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(this.process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public static class StatisticsEntry<EP extends StatisticsSerializeParams> {
        private EP params;
        private NativeRegionSummationElementAmount summation;

        public void clearRedundancyFields() {
            this.summation.clearRedundancyFields();
        }

        public StatisticsEntry() {
        }

        public StatisticsEntry(EP params, NativeRegionSummationElementAmount summation) {
            this.params = params;
            this.summation = summation;
        }

        public EP getParams() {
            return this.params;
        }

        public void setParams(EP params) {
            this.params = params;
        }

        public NativeRegionSummationElementAmount getSummation() {
            return this.summation;
        }

        public void setSummation(NativeRegionSummationElementAmount summation) {
            this.summation = summation;
        }
    }
}

