/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.result;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.function.Supplier;

public class CauseBiResult {
    private static String emptySuccessCause = "\u7f3a\u5c11\u6210\u529f\u7684\u7406\u7531";
    private final boolean success;
    private final String cause;

    private CauseBiResult(boolean success, String cause, Object ... params) {
        AssertUtil.assertMethodRequire(cause, "cause");
        this.success = success;
        this.cause = String.format(cause, params);
    }

    public static CauseBiResult of(boolean success, String cause, Object ... params) {
        return new CauseBiResult(success, cause, params);
    }

    public static CauseBiResult ofSuccess() {
        return CauseBiResult.ofSuccess(emptySuccessCause, new Object[0]);
    }

    public static CauseBiResult ofSuccess(String cause, Object ... params) {
        return CauseBiResult.of(true, cause, params);
    }

    public static CauseBiResult ofFailure(String cause, Object ... params) {
        return CauseBiResult.of(false, cause, params);
    }

    public boolean ifFailure() {
        return !this.ifSuccess();
    }

    public boolean ifSuccess() {
        return this.success;
    }

    public <T extends CustomException> void assertSuccess(CustomExceptionSupplier exceptionSupplier) throws T {
        if (this.ifFailure()) {
            throw exceptionSupplier.supply(this.getCause());
        }
    }

    public String getCause() {
        return this.cause;
    }

    public String titleOfStatus(Supplier<String> successSupplier, Supplier<String> failureSupplier) {
        return this.titleOfStatus(successSupplier.get(), failureSupplier.get());
    }

    public String titleOfStatus(String success, String failure) {
        return this.ifSuccess() ? success : failure;
    }

    public String summaryMessage() {
        return String.format("success?%s,\u72b6\u6001\u4e3a:%s,cause:%s", this.success, this.titleOfStatus("\u6210\u529f", "\u5931\u8d25"), this.cause);
    }

    public String toString() {
        return String.format("success?%s,title:%s,cause:%s", this.success, this.titleOfStatus("\u6210\u529f", "\u5931\u8d25"), this.cause);
    }
}

