/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.schedule;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.schedule.HeartBeatCounter;
import com.mini.framework.util.schedule.SimpleCurrSiteIdTask;
import com.mini.framework.util.schedule.SiteScheduled;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.event.EventListener;

public interface MultiSiteScheduleDispatchUtil {
    public static final Logger logger = LogManager.getLogger(MultiSiteScheduleDispatchUtil.class);
    public static final Map<String, HeartBeatCounter> taskMap = new ConcurrentHashMap<String, HeartBeatCounter>();
    public static final Map<String, Integer> siteTimePoints = new ConcurrentHashMap<String, Integer>();

    public Set<String> currSiteIds();

    default public Map<String, HeartBeatCounter> currentTaskMap() {
        return taskMap;
    }

    default public void findAndPushTask(Method method) {
        SiteScheduled scheduled = method.getAnnotation(SiteScheduled.class);
        if (scheduled != null) {
            Event5WBuilder event = Event5WBuilder.event(3, "multiSiteDispatch").what("\u53d1\u73b0\u5e76\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1:%s", method).why("\u627e\u5230\u503c\u4e3a:[%s]\u7684\u5f85\u6267\u884c\u65b9\u6cd5", scheduled.taskId());
            logger.log(MiniLogLevel.getFrameWorkLog(), (Object)event);
            AssertUtil.assertSupport(!this.currentTaskMap().containsKey(scheduled.taskId()), "\u4e0d\u5141\u8bb8\u5b58\u5728\u4e00\u6837\u4efb\u52a1id:%s", scheduled.taskId());
            this.assertMethodHadSpringEventListener(method, scheduled.taskId());
            int delay = scheduled.fixedDelay();
            int rate = scheduled.fixedRate();
            if (scheduled.fixedDisturb() > 0) {
                delay += RandomUtils.nextInt((int)(2 * scheduled.fixedDisturb())) - scheduled.fixedDisturb();
                rate += RandomUtils.nextInt((int)(2 * scheduled.fixedDisturb())) - scheduled.fixedDisturb();
            } else if (scheduled.fixedDisturb() != 0) {
                throw new ServerException(Status.Server.programConfigJava, "SiteScheduled\u914d\u7f6e\u7684fixedDisturb\u503c\u9519\u8bef", new Object[]{scheduled.fixedDisturb()});
            }
            AssertUtil.assertNotFatal(delay > 0, "SiteScheduled\u914d\u7f6e \u8ba1\u7b97\u51fa\u6765\u7684delay:[%s]\u5e94\u8be5\u5927\u4e8e0,%s", delay, scheduled);
            AssertUtil.assertNotFatal(rate > 0, "SiteScheduled\u914d\u7f6e \u8ba1\u7b97\u51fa\u6765\u7684rate:[%s]\u5e94\u8be5\u5927\u4e8e0,%s", rate, scheduled);
            this.currentTaskMap().put(scheduled.taskId(), new HeartBeatCounter(delay, rate));
        }
    }

    default public void assertMethodHadSpringEventListener(Method method, String taskId) {
        AssertUtil.assertMethodRequire(method, "method");
        EventListener eventListener = method.getAnnotation(EventListener.class);
        AssertUtil.assertSupport(eventListener != null, "\u65b9\u6cd5%s\u5fc5\u987b\u6709\u4e8b\u4ef6\u76d1\u542c\u6ce8\u89e3", method);
        String condition = eventListener.condition();
        AssertUtil.assertSupport(condition.equals(String.format("#task.taskId=='%s'", taskId)), "\u65b9\u6cd5%s\u4e0a\u7684\u4e8b\u4ef6\u76d1\u542c\u6761\u4ef6\u5fc5\u987b\u4e0eSiteScheduled\u6807\u8bb0\u7684:[%s]\u4e00\u81f4", method, taskId);
    }

    default public Collection<SimpleCurrSiteIdTask> heartbeat() {
        ArrayList<SimpleCurrSiteIdTask> tasks = new ArrayList<SimpleCurrSiteIdTask>();
        for (Map.Entry<String, Integer> sitePoint : siteTimePoints.entrySet()) {
            String siteId = sitePoint.getKey();
            int timePoint = sitePoint.getValue();
            sitePoint.setValue(timePoint + 1);
            for (Map.Entry<String, HeartBeatCounter> entry : this.currentTaskMap().entrySet()) {
                String taskId = entry.getKey();
                HeartBeatCounter counter = entry.getValue();
                boolean match = counter.nextHeartbeat(timePoint);
                if (!match) continue;
                tasks.add(new SimpleCurrSiteIdTask(siteId, taskId));
            }
        }
        return tasks;
    }

    default public void init() {
        Set<String> tempSiteIds = this.currSiteIds();
        tempSiteIds.forEach(siteId -> this.reflashSite((String)siteId));
    }

    default public void sureSite(String siteId) {
        if (!siteTimePoints.containsKey(siteId)) {
            siteTimePoints.put(siteId, 0);
        }
    }

    default public void reflashSite(String siteId) {
        siteTimePoints.put(siteId, 0);
    }
}

