/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.mini.framework.core.exception.HandleStringJsonException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.gson.DateMilliSecondDeserializer;
import com.mini.framework.util.string.gson.DateMilliSecondSerializer;
import com.mini.framework.util.string.gson.DateSecondDeserializer;
import com.mini.framework.util.string.gson.DateSecondSerializer;
import com.mini.framework.util.string.gson.deserializer.GsonUnknownTypeable;
import com.mini.framework.util.string.gson.deserializer.UnknownTypeInBeanDeserializer;
import com.mini.framework.util.string.gson.deserializer.UnknownTypeInGsonMapDeserializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;

public class GsonUtil {
    public static UnaryOperator<GsonBuilder> registerMilliSecondDate() {
        return builder -> builder.setDateFormat(1).registerTypeAdapter(Date.class, (Object)new DateMilliSecondDeserializer()).registerTypeAdapter(Date.class, (Object)new DateMilliSecondSerializer());
    }

    public static UnaryOperator<GsonBuilder> registerSecondDate() {
        return builder -> builder.setDateFormat(1).registerTypeAdapter(Date.class, (Object)new DateSecondDeserializer()).registerTypeAdapter(Date.class, (Object)new DateSecondSerializer());
    }

    public static UnaryOperator<GsonBuilder> handleUnknownTypeInGsonMap() {
        return builder -> builder.registerTypeHierarchyAdapter(LinkedTreeMap.class, (Object)new UnknownTypeInGsonMapDeserializer());
    }

    public static <T extends GsonUnknownTypeable<T>> UnaryOperator<GsonBuilder> handleUnknownTypeInBean(Class<T> clazz) {
        return builder -> builder.registerTypeHierarchyAdapter(clazz, new UnknownTypeInBeanDeserializer(clazz));
    }

    public static GsonBuilder createBaseBuilder() {
        return GsonUtil.createBaseBuilder(UnaryOperator.identity());
    }

    public static GsonBuilder createBaseBuilder(UnaryOperator<GsonBuilder> operator) {
        return (GsonBuilder)operator.apply(new GsonBuilder().disableHtmlEscaping());
    }

    public static Gson buildMilliSecondDateGson(UnaryOperator<GsonBuilder> operator) {
        GsonBuilder builder = GsonUtil.createBaseBuilder();
        builder = (GsonBuilder)operator.andThen(GsonUtil.registerMilliSecondDate()).apply(builder);
        return builder.create();
    }

    public static Gson buildMilliSecondDateGson() {
        return GsonUtil.buildMilliSecondDateGson(UnaryOperator.identity());
    }

    public static Gson buildSecondDateGson() {
        GsonBuilder builder = new GsonBuilder().setDateFormat(1).registerTypeAdapter(Date.class, (Object)new DateSecondDeserializer()).registerTypeAdapter(Date.class, (Object)new DateSecondSerializer());
        return builder.disableHtmlEscaping().create();
    }

    public static <E> E fromJson(String json, Class<E> clazz) {
        return GsonUtil.fromJson(json, clazz, new Gson());
    }

    public static <E> E fromJson(String json, Class<E> clazz, Gson gson) {
        AssertUtil.assertMethodRequire(json, "json");
        AssertUtil.assertNotFatal(json.length() > 0, "json \u7684\u957f\u5ea6\u4e3a0\u662f\u65e0\u610f\u4e49\u7684", new Object[0]);
        try {
            return (E)gson.fromJson(json, clazz);
        }
        catch (JsonParseException | IllegalStateException e) {
            String jsonError = StringUtils.abbreviate((String)json, (int)200);
            throw new HandleStringJsonException(e, "json\u8f6c\u6362\u5931\u8d25:[%s]", new Object[]{jsonError});
        }
    }

    public static <E> List<E> fromListJson(Class<E> clazz, String listJson, Gson gson) {
        JsonParser parser = new JsonParser();
        JsonArray jsonArray = parser.parse(listJson).getAsJsonArray();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (JsonElement user : jsonArray) {
            Object element = gson.fromJson(user, clazz);
            elements.add(element);
        }
        return elements;
    }

    public static Map<String, String> fromStringMap(String stringMapJson, Gson gson) {
        Map objectMap = (Map)gson.fromJson(stringMapJson, new TypeToken<Map<String, String>>(){}.getType());
        return objectMap;
    }

    public static Map<Integer, Integer> fromIntegerMap(String stringMapJson, Gson gson) {
        Map objectMap = (Map)gson.fromJson(stringMapJson, new TypeToken<Map<Integer, Integer>>(){}.getType());
        return objectMap;
    }
}

