/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.function.FinalUsefulBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PlaceholderVarNameUtil {
    public static String replaceForeach(String input, Map<String, String> params, Function<String, String> defaultValueFunction) {
        AssertUtil.assertMethodRequire(input, "input");
        return PlaceholderVarNameUtil.replaceForeach(input, (String name) -> Optional.ofNullable(params.get(name)), defaultValueFunction);
    }

    public static String replaceForeach(String input, Map<String, String> params, String defaultValue) {
        return PlaceholderVarNameUtil.replaceForeach(input, (String name) -> Optional.ofNullable(params.get(name)), defaultValue);
    }

    public static String replaceForeach(String input, Function<String, Optional<String>> paramFromName, String defaultValue) {
        AssertUtil.assertMethodRequire(defaultValue, "defaultValue");
        return PlaceholderVarNameUtil.replaceForeach(input, paramFromName, (String key) -> defaultValue);
    }

    public static String replaceForeach(String input, Function<String, Optional<String>> paramFromName, Function<String, String> defaultValueFunction) {
        AssertUtil.assertMethodRequire(input, "input");
        AssertUtil.assertMethodRequire(defaultValueFunction, "defaultValueFunction");
        FinalUsefulBean<String> bean = FinalUsefulBean.of(input);
        PlaceholderVarNameUtil.getPlaceholderMapper(input).forEach((replace, name) -> {
            String value = ((Optional)paramFromName.apply((String)name)).orElseGet(() -> (String)defaultValueFunction.apply((String)name));
            bean.apply(v -> StringUtils.replace((String)v, (String)replace, (String)value));
        });
        return bean.get();
    }

    public static Set<String> getPlaceholderKeys(String input) {
        return PlaceholderVarNameUtil.getPlaceholderMapper(input).values().stream().collect(Collectors.toSet());
    }

    public static Map<String, String> getPlaceholderMapper(String input) {
        AssertUtil.assertMethodRequire(input, "input");
        Matcher match = Pattern.compile("\\$\\{([a-zA-Z0-9_]*)\\}").matcher(input);
        HashMap<String, String> placeholderMapper = new HashMap<String, String>(2);
        while (match.find()) {
            String key = match.group();
            String name = match.group(1);
            placeholderMapper.put(key, name);
        }
        return placeholderMapper;
    }
}

