/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.bean.SplitItemPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil {
    public static String getMatch(String regex, String input) {
        AssertUtil.assertMethodRequire(regex, "regex");
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(input);
        if (match.find()) {
            return match.group();
        }
        return null;
    }

    public static List<String> getMatchPoints(String regex, String input) {
        AssertUtil.assertMethodRequire(regex, "regex");
        String match = RegexUtil.getMatch(String.format("(%s)", regex), input, 1);
        if (match != null) {
            input = StringUtils.substringAfter((String)input, (String)match);
            List<String> subMatchs = RegexUtil.getMatchPoints(regex, input);
            subMatchs.add(0, match);
            return subMatchs;
        }
        return new ArrayList<String>();
    }

    public static String regexCharsAsNormal(String match) {
        String regexChars = "${}()?*";
        return RegexUtil.regexCharsAsNormal(match, regexChars);
    }

    public static String regexCharsAsNormal(String match, String regexChars) {
        for (int i = 0; i < regexChars.length(); ++i) {
            String regexChar = String.valueOf(regexChars.charAt(i));
            match = match.replace(regexChar, "\\" + regexChar);
        }
        return match;
    }

    @Deprecated
    public static String splitByPointEachHande(String pointRegex, String input, Function<String, String> handler) {
        return RegexUtil.splitByPointEachHandle(pointRegex, input, handler);
    }

    public static String splitByPointEachHandle(String pointRegex, String input, Function<String, String> handler) {
        AssertUtil.assertMethodRequire(pointRegex, "pointRegex");
        AssertUtil.assertMethodRequire(input, "input");
        AssertUtil.assertMethodRequire(handler, "handler");
        SplitItemPoint items = RegexUtil.getSplitItemPoint(pointRegex, input);
        items.foreach(handler);
        return items.assem();
    }

    public static SplitItemPoint getSplitItemPoint(String pointRegex, String input) {
        List<String> points = RegexUtil.getMatchPoints(pointRegex, input);
        ArrayList<String> items = new ArrayList<String>();
        for (String point : points) {
            int offset = input.indexOf(point);
            String item = input.substring(0, offset);
            items.add(item);
            input = StringUtils.substringAfter((String)input, (String)point);
        }
        items.add(input);
        return new SplitItemPoint(items, points);
    }

    public static Optional<List<String>> getMatchItems(String regex, String input) {
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(input);
        ArrayList<String> items = null;
        if (match.find()) {
            int count = match.groupCount();
            items = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                items.add(match.group(i + 1));
            }
            return Optional.of(items);
        }
        return Optional.empty();
    }

    public static String getMatch(String regex, String input, int patternIndex) {
        String[] results = RegexUtil.getMatch(regex, input, new int[]{patternIndex});
        if (results == null) {
            return null;
        }
        return results[0];
    }

    public static String[] getMatch(String regex, String input, int ... patternIndexs) {
        AssertUtil.assertMethodRequire(regex, "regex");
        AssertUtil.assertMethodRequire(input, "input");
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(input);
        if (match.find()) {
            String[] results = new String[patternIndexs.length];
            for (int i = 0; i < results.length; ++i) {
                AssertUtil.simpleAssertByStatus(match.groupCount() >= patternIndexs[i], Status.Busy.fatalBug, "\u6b63\u5219[%s]\u4e2d\u6ca1\u6709\u7d22\u5f15\u4e3a[%s]\u7684\u5339\u914d\u7ec4,\u9700\u8981\u9a6c\u4e0a\u4fee\u6539\u4ee3\u7801", regex, patternIndexs[i]);
                AssertUtil.simpleAssertByStatus(0 <= patternIndexs[i], Status.Busy.fatalBug, "\u67e5\u8be2\u7684\u7ec4\u7d22\u5f15\u4e0d\u80fd\u5c0f\u4e8e0", new Object[0]);
                results[i] = match.group(patternIndexs[i]);
            }
            return results;
        }
        return null;
    }

    public static String getUrlDomain(String url) {
        String domain = RegexUtil.getUrlDomainWithPort(url);
        return StringUtils.substringBefore((String)domain, (String)":");
    }

    public static String getUrlDomainWithPort(String url) {
        return RegexUtil.getMatch("https?://+([^/]*)", url, 1);
    }

    public static String getUrlHost(String url) {
        String host = RegexUtil.getMatch("(http[s]{0,1}://+[^/]*)", url, 1);
        return host;
    }

    public static String getUrlNamespace(String url) {
        String namespace = RegexUtil.getMatch("http[s]{0,1}://[^/]*(.*)", url, 1);
        return namespace;
    }

    public static String getUrlParams(String url, String name) {
        String value = RegexUtil.getMatch(String.format("[\\?&]%s=([^&]+)", name), url, 1);
        return value;
    }

    public static String xmlRegexNodeValue(String nodeName, String xml) {
        String regex = String.format("<%s>.*\\[(.*)\\].*\\].*</%s>", nodeName, nodeName);
        String value = RegexUtil.getMatch(regex, xml, 1);
        return value;
    }

    public static boolean md5Match(String md5, boolean long32or16, boolean charLower) {
        String regex = String.format("^[0-9%s]{%s}$", charLower ? "a-f" : "A-F", long32or16 ? 32 : 16);
        return RegexUtil.getMatch(regex, md5) != null;
    }

    public static String applyPlaceholder(String input, Map<String, Object> params) {
        return RegexUtil.applyPlaceholder(input, params, " ");
    }

    public static Optional<int[]> getFromToIndex(String searchChar, String input) {
        int fromIndex = StringUtils.indexOf((CharSequence)input, (CharSequence)searchChar);
        if (fromIndex >= 0) {
            return Optional.of(new int[]{fromIndex, fromIndex + searchChar.length()});
        }
        return Optional.empty();
    }

    public static String applyPlaceholder(String input, Map<String, Object> params, String defaultValue) {
        return RegexUtil.applyPlaceholder(input, params, (String name) -> defaultValue);
    }

    public static String applyPlaceholder(String input, Map<String, Object> params, Function<String, String> defaultValueFunction) {
        AssertUtil.assertMethodRequire(defaultValueFunction, "defaultValueFunction");
        AssertUtil.assertMethodRequire(params, "params");
        AssertUtil.assertMethodRequire(input, "input");
        input = " " + input;
        String regex = "\\$\\{([a-zA-Z0-9]+)(\\!?[^\\!^\\}]*)\\}";
        Pattern pattern = Pattern.compile(regex);
        boolean tryMatch = false;
        do {
            String defMatch;
            tryMatch = false;
            Matcher match = pattern.matcher(input);
            if (!match.find() || !match.find(1)) continue;
            String name = match.group(1);
            String def = null;
            if (match.find(2) && (defMatch = match.group(2)).length() > 0) {
                def = defMatch.substring(1);
            }
            Object val = Optional.ofNullable(params.get(name)).orElse(def);
            AssertUtil.assertNoBadReq((val = Optional.ofNullable(val).orElseGet(() -> (String)defaultValueFunction.apply(name))) != null, Status.BadReq.illParam, "defaultValueFunction\u4e0d\u5141\u8bb8\u8fd4\u56de\u7a7a", new Object[0]);
            if (val instanceof Supplier) {
                val = ((Supplier)val).get();
            }
            input = match.replaceFirst(String.valueOf(val));
            tryMatch = true;
        } while (tryMatch);
        String exRegex = "\\$\\{.*\\}";
        String errorPlaceHolder = RegexUtil.getMatch(exRegex, input);
        if (errorPlaceHolder != null) {
            throw new BadReqException(Status.BadReq.illPlaceHolder, "\u65e0\u6cd5\u89e3\u6790\u7684\u5360\u4f4d\u7b26:[%s]", new Object[]{errorPlaceHolder}).detail("placeHolder", (Object)errorPlaceHolder);
        }
        return input.substring(1);
    }
}

