/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.asserts.AssertUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static String utf8 = "utf-8";

    public static byte[] getUtf8Byte(String str) {
        try {
            return str.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u628a[%s]\u5f97\u5230utf-8\u7f16\u7801\u65f6\u9519\u8bef", new Object[]{str});
        }
    }

    public static String toUtf8String(byte[] bytes) {
        try {
            return new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u628a[%s]\u7528utf-8\u7f16\u7801\u6210\u5b57\u7b26\u4e32\u65f6\u9519\u8bef", new Object[]{bytes});
        }
    }

    public static String fen2yuan(long fen) {
        return fen / 100L + "." + StringUtils.leftPad((String)String.valueOf(fen % 100L), (int)2, (String)"0");
    }

    public static String fen2yuan(int fen) {
        return fen / 100 + "." + StringUtils.leftPad((String)String.valueOf(fen % 100), (int)2, (String)"0");
    }

    public static Optional<Integer> yuan2fen(String yuan) {
        AssertUtil.assertMethodRequire(yuan, "yuan");
        if (yuan.startsWith(".")) {
            yuan = "0" + yuan;
        }
        String[] items = StringUtils.split((String)yuan, (String)".");
        String first = items[0];
        if (items.length == 1) {
            if (StringUtils.isNumeric((CharSequence)first) && first.length() > 0) {
                return Optional.of(Integer.parseInt(first) * 100);
            }
        } else if (items.length == 2) {
            String second = items[1];
            Integer secondMoney = 0;
            if (!StringUtils.isNumeric((CharSequence)second) || second.length() > 2 || second.length() <= 0) {
                return Optional.empty();
            }
            secondMoney = Integer.parseInt(second);
            if (first.length() > 0) {
                return Optional.of(Integer.parseInt(first) * 100 + secondMoney);
            }
            if (first.length() == 0) {
                return Optional.of(secondMoney);
            }
        }
        return Optional.empty();
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, utf8);
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u628a[%s]\u7528urlEncode\u7f16\u7801\u65f6\u9519\u8bef", new Object[]{url});
        }
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, utf8);
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u628a[%s]\u7528urlDecode\u89e3\u7801\u65f6\u9519\u8bef", new Object[]{url});
        }
    }

    public static String[] splitByNotWords(String keyword) {
        keyword = keyword.replaceAll("[^a-zA-Z0-9\u4e00-\u9fa5]", " ");
        String[] keys = StringUtils.split((String)keyword, null);
        keys = Arrays.asList(keys).stream().filter(key -> key != null && key.length() > 0).distinct().collect(Collectors.toList()).toArray(keys);
        return keys;
    }
}

