/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.gson.format;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.ArrayUtil;
import com.mini.framework.util.export.ExcelColumnDeclares;
import com.mini.framework.util.export.ExcelExportSupport;
import com.mini.framework.util.function.PredicateSpread;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.gson.format.CommandParams;
import com.mini.framework.util.string.gson.format.ExportResourceFromByte;
import com.mini.framework.util.string.gson.format.bean.Json;
import com.mini.framework.util.string.gson.format.flag.ResponseExportType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsonDataFormatBean {
    private static Logger logger = LogManager.getLogger(GsonDataFormatBean.class);
    private Object origin;
    private JsonElement currentObject;
    private List<ExcelColumnDeclares> excelColumnDeclareList;
    private ExportResourceFromByte exportResourceFunction;

    public static GsonDataFormatBean build(ExportResourceFromByte exportResourceFunction, List<ExcelColumnDeclares> excelColumnDeclaresList, Object object) {
        GsonDataFormatBean gsonDataFormat = new GsonDataFormatBean();
        gsonDataFormat.setOrigin(object);
        gsonDataFormat.getCurrent();
        gsonDataFormat.excelColumnDeclareList = excelColumnDeclaresList;
        AssertUtil.assertNotFatalBug(exportResourceFunction != null, "\u53c2\u6570 exportResourceFunction \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        gsonDataFormat.exportResourceFunction = exportResourceFunction;
        return gsonDataFormat;
    }

    private JsonElement useAsJson(Object target) {
        if (target instanceof JsonElement) {
            return (JsonElement)target;
        }
        return this.gsonForUse().toJsonTree(target);
    }

    private JsonElement getCurrent() {
        if (this.currentObject == null) {
            this.currentObject = this.gsonForUse().toJsonTree(this.origin);
        }
        return this.currentObject;
    }

    private Gson gsonForUse() {
        return GsonUtil.buildMilliSecondDateGson(GsonBuilder::serializeNulls);
    }

    private List<JsonObject> getObject(JsonElement jsonElement, String ... names) {
        AssertUtil.assertMethodRequire(jsonElement, "jsonElement");
        AssertUtil.assertSupport(names != null, "names\u957f\u5ea6\u8981\u5927\u4e8e1", new Object[0]);
        ArrayList<JsonObject> elements = new ArrayList<JsonObject>();
        if (jsonElement.isJsonNull()) {
            return elements;
        }
        if (jsonElement.isJsonObject()) {
            if (names.length == 0) {
                elements.add(jsonElement.getAsJsonObject());
            } else {
                JsonElement subJson = jsonElement.getAsJsonObject().get(names[0]);
                if (subJson != null) {
                    elements.addAll(this.getObject(subJson, (String[])ArrayUtils.subarray((Object[])names, (int)1, (int)names.length)));
                }
            }
        } else if (jsonElement.isJsonArray()) {
            for (JsonElement subJsonElement : jsonElement.getAsJsonArray()) {
                elements.addAll(this.getObject(subJsonElement, names));
            }
        } else {
            logger.debug("\u53d1\u73b0\u4e00\u4e2a\u6ca1\u6709\u5904\u7406\u7684jsonElement, names:{},jsonElement:{}", (Object)jsonElement, (Object)Arrays.toString(names));
        }
        return elements;
    }

    private List<JsonObject> getObject(String namespace) {
        String[] names = namespace.split("\\.");
        if (names[0].length() == 0) {
            names = new String[]{};
        }
        JsonElement element = this.getCurrent();
        return this.getObject(element, names);
    }

    public void addRootProperty(String name, Object property) {
        this.getCurrent().getAsJsonObject().add(name, this.useAsJson(property));
    }

    private void retain(JsonObject jsonObject, String ... names) {
        List keys = jsonObject.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        keys.removeAll(Arrays.asList(names));
        for (String key : keys) {
            jsonObject.remove(key);
        }
    }

    public GsonDataFormatBean remove(String namespace, String ... names) {
        AssertUtil.assertNoBadReq(namespace != null, Status.BadReq.noReq, "namespace\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        List<JsonObject> objects = this.getObject(namespace);
        for (String name : names) {
            for (JsonObject object : objects) {
                object.remove(name);
            }
        }
        return this;
    }

    public GsonDataFormatBean union(String mainNamespace, String mainKey, String unionNamespace, String unionKey, String ... unionNames) {
        List<JsonObject> mainObjects = this.getObject(mainNamespace);
        for (JsonObject mainObject : mainObjects) {
            this.union(mainObject, mainKey, unionNamespace, unionKey, unionNames);
        }
        return this;
    }

    private void union(JsonObject mainObject, String mainKey, String unionNamespace, String unionKey, String ... unionNames) {
        JsonElement foundElement;
        List<JsonObject> unionDataList = this.getObject(unionNamespace);
        JsonElement mainElement = mainObject.getAsJsonObject().get(mainKey);
        if (mainElement != null && !mainElement.isJsonNull() && (foundElement = (JsonElement)ArrayUtil.findElement(mainElement, unionDataList, unionElement -> unionElement.getAsJsonObject().get(unionKey))) != null && foundElement.isJsonObject()) {
            JsonObject unionObject = foundElement.getAsJsonObject();
            for (String unionName : unionNames) {
                mainObject.add(unionName, unionObject.get(unionName));
            }
        }
    }

    public GsonDataFormatBean retain(String namespace, String ... names) {
        AssertUtil.assertNoBadReq(namespace != null, Status.BadReq.noReq, "namespace\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        List<JsonObject> objects = this.getObject(namespace);
        for (JsonObject object : objects) {
            this.retain(object, names);
        }
        return this;
    }

    public GsonDataFormatBean merge(String mainNamespace, String mainKey, String mergeNamespace, String mergeKey, String alias) {
        List<JsonObject> mainObjects = this.getObject(mainNamespace);
        for (JsonObject mainObject : mainObjects) {
            this.merge(mainObject, mainKey, mergeNamespace, mergeKey, alias);
        }
        return this;
    }

    private void merge(JsonObject main, String mainKey, String mergeNamespace, String mergeKey, String alias) {
        JsonElement foundElement;
        List<JsonObject> mergeDataList = this.getObject(mergeNamespace);
        JsonElement mainElement = main.getAsJsonObject().get(mainKey);
        if (mainElement != null && !mainElement.isJsonNull() && (foundElement = (JsonElement)ArrayUtil.findElement(mainElement, mergeDataList, mergeElement -> mergeElement.getAsJsonObject().get(mergeKey))) != null) {
            main.getAsJsonObject().add(alias, foundElement);
        }
    }

    public GsonDataFormatBean mergeList(String mainNamespace, String mainKey, String mergeNamespace, String mergeKey, String listAlias) {
        List<JsonObject> mainObjects = this.getObject(mainNamespace);
        for (JsonObject mainObject : mainObjects) {
            this.mergeList(mainObject, mainKey, mergeNamespace, mergeKey, listAlias);
        }
        return this;
    }

    private void mergeList(JsonObject main, String mainKey, String mergeNamespace, String mergeKey, String listAlias) {
        List<JsonObject> mergeDataList = this.getObject(mergeNamespace);
        JsonElement mainElement = main.getAsJsonObject().get(mainKey);
        JsonArray jsonArray = new JsonArray();
        if (mainElement != null && !mainElement.isJsonNull()) {
            List list = mergeDataList.stream().filter(mergeElement -> mainElement.equals(mergeElement.getAsJsonObject().get(mergeKey))).collect(Collectors.toList());
            for (JsonObject jo : list) {
                jsonArray.add((JsonElement)jo);
            }
        }
        main.getAsJsonObject().add(listAlias, (JsonElement)jsonArray);
    }

    public GsonDataFormatBean mapper(String mainNamespace, String mapperKey, String mapDataNamespace, String alias) {
        List<JsonObject> mainObjects = this.getObject(mainNamespace);
        for (JsonObject mainObject : mainObjects) {
            this.mapper(mainObject, mapperKey, mapDataNamespace, alias);
        }
        return this;
    }

    private void mapper(JsonObject mainObject, String mapperKey, String mapDataNamespace, String alias) {
        List<JsonObject> mapDataList = this.getObject(mapDataNamespace);
        AssertUtil.assertNoBadReq(mapDataList.size() <= 1, Status.BadReq.illParam, "\u7ed3\u679c\u4e2dpath:[%s]\u5bf9\u5e94\u7684\u6570\u636e\u4e2a\u6570(%s)\u6700\u591a\u53ea\u80fd\u662f1", mapDataNamespace, mapDataList.size());
        Optional<JsonElement> keyElementOptional = Optional.ofNullable(mainObject.get(mapperKey)).filter(PredicateSpread.of(JsonElement::isJsonNull).negate());
        if (!mapDataList.isEmpty() && keyElementOptional.isPresent()) {
            mainObject.add(alias, this.getElementAsStringKey(mapDataList.get(0), keyElementOptional.get()));
        }
    }

    private JsonElement getElementAsStringKey(JsonObject object, JsonElement key) {
        String keyString = key.getAsString();
        Map<String, JsonElement> objectMap = object.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (JsonElement)e.getValue()));
        return objectMap.get(keyString);
    }

    public GsonDataFormatBean alias(String namespace, String sourceName, String aliasName) {
        List<JsonObject> objects = this.getObject(namespace);
        for (JsonObject object : objects) {
            this.alias(object, sourceName, aliasName);
        }
        return this;
    }

    public GsonDataFormatBean rename(String namespace, String oldName, String newName) {
        List<JsonObject> objects = this.getObject(namespace);
        for (JsonObject object : objects) {
            this.rename(object, oldName, newName);
        }
        return this;
    }

    public GsonDataFormatBean json(Json.Action action, String namespace, String targetKey, String resultAlias) {
        List<JsonObject> objects = this.getObject(namespace);
        for (JsonObject object : objects) {
            this.json(action, object, targetKey, resultAlias);
        }
        return this;
    }

    public GsonDataFormatBean concat(String namespace, String alias, String nullAs, String spilt, String ... items) {
        List<JsonObject> objects = this.getObject(namespace);
        for (JsonObject object : objects) {
            this.concat(object, alias, nullAs, spilt, items);
        }
        return this;
    }

    private void concat(JsonObject object, String alias, String nullAs, String spilt, String ... items) {
        String concat = Stream.of(items).map(item -> {
            JsonElement itemJsonObject = object.get(item);
            String itemObject = itemJsonObject == null || itemJsonObject.isJsonNull() ? nullAs : itemJsonObject.getAsString();
            return itemObject;
        }).collect(Collectors.joining(spilt));
        object.addProperty(alias, concat);
    }

    private void alias(JsonObject object, String sourceName, String aliasName) {
        JsonElement element = object.get(sourceName);
        if (element != null) {
            object.add(aliasName, element);
        }
    }

    private void rename(JsonObject object, String oldName, String newName) {
        JsonElement element = object.remove(oldName);
        if (element != null) {
            object.add(newName, element);
        }
    }

    private void json(Json.Action action, JsonObject object, String targetKey, String resultAlias) {
        JsonElement element = object.get(targetKey);
        if (element != null && !element.isJsonNull()) {
            switch (action) {
                case deserialize: {
                    JsonElement result = (JsonElement)this.gsonForUse().fromJson(element.getAsString(), JsonElement.class);
                    object.add(resultAlias, result);
                    break;
                }
                case serialize: {
                    object.addProperty(resultAlias, this.gsonForUse().toJson(element));
                    break;
                }
                default: {
                    throw new ServerException(Status.Server.programConfigJavaFramework, "\u53d1\u73b0\u6ca1\u6709\u5b9a\u4e49\u7684json action:%s", new Object[]{action});
                }
            }
        }
    }

    public GsonDataFormatBean fill(String namespace, String name, Object value) {
        List<JsonObject> objects = this.getObject(namespace);
        for (JsonObject object : objects) {
            this.fill(object, name, value);
        }
        return this;
    }

    private void fill(JsonObject object, String name, Object value) {
        object.add(name, GsonUtil.buildMilliSecondDateGson().toJsonTree(value));
    }

    private GsonDataFormatBean exportExcel(String excelName) {
        ExcelColumnDeclares matchDeclare = this.excelColumnDeclareList.stream().filter(declare -> declare.name().equals(excelName)).findFirst().orElseThrow(() -> new BadReqException(Status.BadReq.illParam, "\u5bfc\u51faexcel\u65f6\u6ca1\u6709\u53d1\u73b0excel\u540d\u5b57:[%s]", new Object[]{excelName}));
        return this.exportExcel(matchDeclare);
    }

    private GsonDataFormatBean exportExcel(ExcelColumnDeclares excelColumnDeclares) {
        byte[] bytes = ExcelExportSupport.build(this.currentObject).exportAsBytes(excelColumnDeclares.listRootPath(), Arrays.asList(excelColumnDeclares.value()));
        AssertUtil.assertNotFatal(this.exportResourceFunction != null, "\u9700\u8981\u4f7f\u7528\u5bfc\u51fa\u4f7f\u7528\u5fc5\u987b\u914d\u7f6e\u6709\u5c5e\u6027:exportResourceFunction", new Object[0]);
        String typeSuffix = "xls";
        String resourcePath = this.exportResourceFunction.exportUrlResource(bytes, typeSuffix);
        this.currentObject = new JsonObject();
        this.currentObject.getAsJsonObject().addProperty("resourcePath", resourcePath);
        return this;
    }

    public GsonDataFormatBean applyCommandsFromExplain(String explain) {
        return this.applyCommandsFromExplain(explain, cp -> {});
    }

    public GsonDataFormatBean applyCommandsFromExplain(String explain, Consumer<List<CommandParams>> beforeApply) {
        List<CommandParams> functionCommands = CommandParams.resolverExplain(explain);
        CommandParams fillAppliedDataFormat = CommandParams.createFromFunctionParams("fill", "", "appliedDataFormat", explain);
        functionCommands.add(fillAppliedDataFormat);
        beforeApply.accept(functionCommands);
        return this.applyFunctionCommands(functionCommands);
    }

    public GsonDataFormatBean applyFunctionCommands(List<CommandParams> functionCommands) {
        block31: for (CommandParams functionCommand : functionCommands) {
            String function = functionCommand.getName();
            Object[] args = functionCommand.getArgs();
            String argsToString = Arrays.toString(args);
            switch (function) {
                case "union": {
                    AssertUtil.assertNoBadReq(args.length > 4, Status.BadReq.illParam, "union\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e4", argsToString);
                    this.union((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String[])ArrayUtils.subarray((Object[])args, (int)4, (int)args.length));
                    continue block31;
                }
                case "remove": {
                    AssertUtil.assertNoBadReq(args.length > 1, Status.BadReq.illParam, "remove\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e1", argsToString);
                    this.remove((String)args[0], (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
                    continue block31;
                }
                case "retain": {
                    AssertUtil.assertNoBadReq(args.length > 1, Status.BadReq.illParam, "retain\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e1", argsToString);
                    this.retain((String)args[0], (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
                    continue block31;
                }
                case "merge": {
                    AssertUtil.assertNoBadReq(args.length == 5, Status.BadReq.illParam, "merge\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e5", argsToString);
                    this.merge((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4]);
                    continue block31;
                }
                case "mergeList": {
                    AssertUtil.assertNoBadReq(args.length == 5, Status.BadReq.illParam, "merge\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e5", argsToString);
                    this.mergeList((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4]);
                    continue block31;
                }
                case "mapper": {
                    AssertUtil.assertNoBadReq(args.length == 4, Status.BadReq.illParam, "mapper\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e4", argsToString);
                    this.mapper((String)args[0], (String)args[1], (String)args[2], (String)args[3]);
                    continue block31;
                }
                case "alias": {
                    AssertUtil.assertNoBadReq(args.length == 3, Status.BadReq.illParam, "alias\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e3", argsToString);
                    this.alias((String)args[0], (String)args[1], (String)args[2]);
                    continue block31;
                }
                case "rename": {
                    AssertUtil.assertNoBadReq(args.length == 3, Status.BadReq.illParam, "rename\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e3", argsToString);
                    this.rename((String)args[0], (String)args[1], (String)args[2]);
                    continue block31;
                }
                case "json": {
                    AssertUtil.assertNoBadReq(args.length == 4, Status.BadReq.illParam, "json\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e4", argsToString);
                    Json.Action action = Json.Action.from((String)args[0]);
                    this.json(action, (String)args[1], (String)args[2], (String)args[3]);
                    continue block31;
                }
                case "fill": {
                    AssertUtil.assertNoBadReq(args.length == 3, Status.BadReq.illParam, "fill\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u7b49\u4e8e3", argsToString);
                    this.fill((String)args[0], (String)args[1], args[2]);
                    continue block31;
                }
                case "concat": {
                    AssertUtil.assertNoBadReq(args.length > 4, Status.BadReq.illParam, "concat\u7684\u53c2\u6570%s\u7684\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e4", argsToString);
                    this.concat((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String[])ArrayUtils.subarray((Object[])args, (int)4, (int)args.length));
                    continue block31;
                }
                case "export": {
                    AssertUtil.assertNoBadReq(args.length == 1 || args.length == 2, Status.BadReq.illParam, "export\u7684\u53c2\u6570%s\u5fc5\u987b\u7b49\u4e8e1\u6216\u80052", argsToString);
                    AssertUtil.assertNotFatal(this.excelColumnDeclareList != null && !this.excelColumnDeclareList.isEmpty(), "\u5fc5\u987b\u914d\u7f6eexcelColumnDeclares\u624d\u80fd\u4f7f\u7528\u5bfc\u51fa\u529f\u80fd\u5f53\u524d\u627e\u5230\u4e86:%s", this.excelColumnDeclareList);
                    ExcelColumnDeclares firstExcelColumnDeclares = (ExcelColumnDeclares)this.excelColumnDeclareList.stream().findFirst().orElseThrow(() -> new BadReqException(Status.BadReq.unsupport, "", new Object[0]));
                    ResponseExportType exportType = ResponseExportType.valueOf((String)args[0]);
                    switch (exportType) {
                        case excel: {
                            if (args.length <= 1) {
                                this.exportExcel(firstExcelColumnDeclares.name());
                                continue block31;
                            }
                            if (args.length == 2) {
                                this.exportExcel((String)args[1]);
                                continue block31;
                            }
                            throw new BadReqException(Status.BadReq.illParam, "\u5bfc\u51fa\u8868\u683cexport,excel\u7684\u547d\u4ee4\u53c2\u6570\u9519\u8bef:%s", new Object[]{Arrays.asList(args)});
                        }
                    }
                    throw new ServerException(Status.Server.programConfigJavaFramework, "\u6ca1\u6709\u5904\u7406\u5bfc\u51fa\u7c7b\u578b:[%s]", new Object[]{exportType});
                }
            }
            throw new BadReqException("\u6682\u65f6\u4e0d\u652f\u6301[%s]\u65b9\u6cd5", new Object[]{function});
        }
        return this;
    }

    public String createString() {
        return this.toString();
    }

    public String toString() {
        return this.currentObject.toString();
    }

    public Object getOrigin() {
        return this.origin;
    }

    public void setOrigin(Object origin) {
        this.origin = origin;
    }

    public static void setLogger(Logger logger) {
        GsonDataFormatBean.logger = logger;
    }

    public List<ExcelColumnDeclares> getExcelColumnDeclareList() {
        return this.excelColumnDeclareList;
    }

    public void setExcelColumnDeclareList(List<ExcelColumnDeclares> excelColumnDeclareList) {
        this.excelColumnDeclareList = excelColumnDeclareList;
    }
}

