/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.json.flag.JsonPathMapping;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class JsonFlagHelper {
    public static <T> T parseFrom(String jsonString, Class<T> clazz) {
        Supplier<Object> instanceSupplier = () -> {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ServerException((Throwable)e, Status.Server.programConfigJava, "\u521b\u5efa\u5b9e\u4f8b\u65f6\u51fa\u9519,%s", new Object[]{clazz});
            }
        };
        return (T)JsonFlagHelper.parseFromFill(jsonString, instanceSupplier);
    }

    public static <T> T parseFromFill(String jsonString, Supplier<T> instanceSupplier) {
        AssertUtil.assertMethodRequire(jsonString, jsonString);
        Object instance = instanceSupplier.get();
        Field[] fields = instance.getClass().getDeclaredFields();
        Stream.of(fields).forEach(field -> {
            JsonPathMapping pathMapping = field.getAnnotation(JsonPathMapping.class);
            if (pathMapping != null) {
                String[] paths = pathMapping.value();
                try {
                    Object value = JsonFlagHelper.parseFirstMatch(jsonString, (message, runtimeException) -> new ServerException((Throwable)runtimeException, Status.Server.programConfigJava, "\u7ed9\u5c5e\u6027:[%s]\u8d4b\u503c\u65f6\u51fa\u9519,%s", new Object[]{field.getName(), message}), paths);
                    field.setAccessible(true);
                    field.set(instance, value);
                    field.setAccessible(false);
                }
                catch (IllegalAccessException e) {
                    throw new ServerException((Throwable)e, Status.Server.programConfigJava, "\u7ed9\u5c5e\u6027:[%s]\u8d4b\u503c\u65f6\u51fa\u9519", new Object[]{field.getName()});
                }
            }
        });
        return instance;
    }

    public static <T, E extends CustomException> T parseFirstMatch(String jsonString, BiFunction<String, RuntimeException, E> exceptionSupplier, String ... pathExplains) {
        LinkedList errors = new LinkedList();
        AssertUtil.assertSupport(pathExplains.length > 0, "pathExplains \u4e0d\u80fd\u4e0d\u4f20\u503c", new Object[0]);
        return (T)Stream.of(pathExplains).map(explain -> {
            try {
                Object result = JsonPath.read((String)jsonString, (String)explain, (Predicate[])new Predicate[0]);
                return result;
            }
            catch (PathNotFoundException e) {
                errors.add(e);
                return null;
            }
            catch (RuntimeException e) {
                throw (CustomException)exceptionSupplier.apply(String.format("\u6839\u636e\u8def\u5f84:[%s]\u53d6\u503c\u5931\u8d25", explain), e);
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            String lastExplain = pathExplains[pathExplains.length - 1];
            RuntimeException lastError = (RuntimeException)errors.getLast();
            return (CustomException)exceptionSupplier.apply(String.format("\u6839\u636e\u8def\u5f84:[%s]\u53d6\u503c\u5931\u8d25", lastExplain), lastError);
        });
    }
}

