/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.surplus.reduce;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.log.MiniLogLevel;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@FunctionalInterface
public interface PersistenceReduceExecutor<K> {
    public static final Logger logger = LogManager.getLogger(PersistenceReduceExecutor.class);

    public boolean executeReduce(K var1, int var2);

    default public Optional<Integer> executeReduceAllowLack(K key, int targetIncrement, int minIncrement) {
        AssertUtil.assertNotFatalProgramConfig(targetIncrement > 0, Status.Server.programConfigJava, "increment:[%s]\u5fc5\u987b\u5927\u4e8e 0", targetIncrement);
        AssertUtil.assertNotFatalProgramConfig(minIncrement > 0, Status.Server.programConfigJava, "minIncrement:[%s]\u5fc5\u987b\u5927\u4e8e 0", minIncrement);
        AssertUtil.assertNotFatalProgramConfig(targetIncrement >= minIncrement, Status.Server.programConfigJava, "increment:[%s]\u4e0d\u80fd\u5c0f\u4e8e minIncrement:[%s]", targetIncrement, minIncrement);
        Event5WBuilder event = Event5WBuilder.event(1, "executeReduceAllowLack").who("\u6301\u4e45\u5c42key:[%s]", key).what("\u6267\u884c\u51cf\u64cd\u4f5c", new Object[0]).how("\u76ee\u6807\u51cf\u5c11\u6570 targetIncrement:[%s],\u6700\u5c11\u53ef\u63a5\u53d7\u51cf\u5c11\u6570 minIncrement:[%s]", targetIncrement, minIncrement);
        logger.debug((Object)event);
        boolean executeSuccess = this.executeReduce(key, targetIncrement);
        logger.debug((Object)event.when("\u6267\u884c\u7ed3\u679c:[%s]", executeSuccess));
        if (executeSuccess) {
            return Optional.of(targetIncrement);
        }
        if (targetIncrement > minIncrement) {
            int nextTargetIncrement = (targetIncrement + minIncrement) / 2;
            AssertUtil.assertNotFatalProgramConfig(nextTargetIncrement != targetIncrement, Status.Server.programConfigJava, "\u4e8c\u5206\u540e\u589e\u91cf\u503c:[%s]\u4e0e\u5f53\u524d\u589e\u91cf\u503c:[%s]\u8fd8\u662f\u4e00\u6837,\u6700\u5c0f\u589e\u91cf\u4e3a:[%s]", nextTargetIncrement, targetIncrement, minIncrement);
            event.why("\u6267\u884c\u5931\u8d25\u540e\u53d1\u8fd8\u6ca1\u6709\u5230\u6700\u5c11\u63a5\u53d7\u91cf\u5373:targetIncrement:[%s] > minIncrement:[%s]", targetIncrement, minIncrement).result("\u4fee\u6539\u76ee\u6807\u589e\u91cf\u518d\u6267\u884c\u5373 nextTargetIncrement:[%s] = (targetIncrement:[%s] + minIncrement:[%s] )/2", nextTargetIncrement, targetIncrement, minIncrement);
            logger.log(MiniLogLevel.getKeyBizLog(), (Object)event);
            return this.executeReduceAllowLack(key, nextTargetIncrement, minIncrement);
        }
        return Optional.empty();
    }
}

