/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.surplus.reduce;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.surplus.reduce.PersistenceReduceExecutor;
import com.mini.framework.util.surplus.reduce.ReduceQueueItem;
import com.mini.framework.util.surplus.reduce.SurplusReduceCacheQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SurplusReduceCacheAgent<K> {
    private static final Logger logger = LogManager.getLogger(SurplusReduceCacheAgent.class);
    private final SurplusReduceCacheQueue surplusReduceCacheQueue;
    private final Integer reduceCacheSize;
    private final Long surplusStatusDelay;

    public Optional<ReduceQueueItem> reduceSurplus(K key, PersistenceReduceExecutor<K> persistenceIncrementExecutor) {
        return ((List)this.reduceSurplus(key, 1, persistenceIncrementExecutor).orElse(new ArrayList())).stream().findFirst();
    }

    public Optional<List<ReduceQueueItem>> reduceSurplus(K key, int size, PersistenceReduceExecutor<K> persistenceIncrementExecutor) {
        AssertUtil.assertNotFatalBug(size > 0, "\u6263\u9664\u5e93\u5b58\u6570:[%s]\u5fc5\u987b\u662f\u6b63\u6570", size);
        Event5WBuilder event = Event5WBuilder.event(2, "cacheAgentReduceSurplus").who("key:[%s]", key).what("\u5c1d\u8bd5\u6267\u884c\u6263\u9664\u5c18:[%s]\u4e2a\u5269\u4f59\u91cf", size);
        logger.debug((Object)event);
        ArrayList<ReduceQueueItem> foundItems = new ArrayList<ReduceQueueItem>();
        boolean cacheLackItem = false;
        int popStepIndex = 1;
        while (!cacheLackItem && foundItems.size() < size) {
            Optional<ReduceQueueItem> cacheItemOptional = this.surplusReduceCacheQueue.popItem(key);
            logger.debug((Object)event.where("\u7b2c?\u6b21/\u603b?\u6b21:[%s/%s]", popStepIndex, size).when("\u4ececacheQueue\u4e2d\u62ff\u5230\u4e86\u7ed3\u679c\u662f:%s", cacheItemOptional));
            if (cacheItemOptional.isPresent()) {
                ReduceQueueItem cacheItem = cacheItemOptional.get();
                if (cacheItem.ifNotLack()) {
                    foundItems.add(cacheItem);
                } else if (cacheItem.ifLackAndEffective()) {
                    foundItems.add(cacheItem);
                } else {
                    logger.debug((Object)event.result("\u5f53\u524d\u627e\u5230\u8bb0\u5f55\u662f\u8fc7\u671f\u4e86\u7684\u76f4\u63a5\u5ffd\u7565\uff0c\u7ee7\u7eed\u5faa\u73af\uff0cfoundItems:%s", foundItems));
                }
            } else {
                cacheLackItem = true;
            }
            ++popStepIndex;
        }
        AssertUtil.assertNotFatalProgramConfig(cacheLackItem != (foundItems.size() == size), Status.Server.programConfigJava, "\u4e0a\u9762while\u4e2d\u5e94\u8be5\u4fdd\u8bc1requireFromPersistence:[%s] != (foundItems.size():[%s]==size:[%s])", cacheLackItem, foundItems.size(), size);
        List<ReduceQueueItem> realUsefulItems = foundItems.stream().filter(ReduceQueueItem::ifNotLack).collect(Collectors.toList());
        logger.debug((Object)event.why("\u5e94\u8be5\u4ece\u7f13\u5b58\u627e\u5230:[%s]\u4e2a\u5b9e\u9645\u627e\u5230:[%s]\u4e2a", size, foundItems.size()));
        if (cacheLackItem) {
            logger.log(MiniLogLevel.getFrameWorkLog(), (Object)event.result("\u628a\u6709\u7528\u7684\u9000\u56de\u5230\u7f13\u5b58\uff0c\u91cd\u65b0\u53bb\u6570\u636e\u5e93\u4e2d\u53d6,\u5e0c\u671b\u53d6:[%s]\u4e2a\u80fd\u63a5\u53d7\u53d6:[%s]\u4e2a", this.reduceCacheSize, 1));
            this.surplusReduceCacheQueue.batchPushItem(key, realUsefulItems);
            Optional<Integer> itemSizeOptional = persistenceIncrementExecutor.executeReduceAllowLack(key, this.reduceCacheSize, 1);
            int gotItemSize = itemSizeOptional.orElse(0);
            Date now = new Date();
            List<ReduceQueueItem> allItemArray = ReduceQueueItem.createEffectiveAndLackItemArray(now, gotItemSize, this.reduceCacheSize - gotItemSize, new Date(), this.surplusStatusDelay);
            logger.debug((Object)event.result("\u5b9e\u9645\u4ece\u6301\u4e45\u5c42\u53d6\u5230:[%s]\u4e2a\u62fc\u88c5\u90e8\u5206\u7f3a\u4e4f\u7684\u540e\u63a8\u5165\u7f13\u5b58%s", gotItemSize, allItemArray));
            this.surplusReduceCacheQueue.batchPushItem(key, allItemArray);
            return this.reduceSurplus(key, size, persistenceIncrementExecutor);
        }
        if (foundItems.stream().allMatch(ReduceQueueItem::ifNotLack)) {
            return Optional.of(foundItems);
        }
        this.surplusReduceCacheQueue.batchPushItem(key, realUsefulItems);
        return Optional.empty();
    }

    public static <K> SurplusReduceCacheAgent<K> createInstance(SurplusReduceCacheQueue<K> surplusReduceCacheQueue, Integer reduceCacheSize, Long surplusStatusDelay) {
        return new SurplusReduceCacheAgent<K>(surplusReduceCacheQueue, reduceCacheSize, surplusStatusDelay);
    }

    private SurplusReduceCacheAgent(SurplusReduceCacheQueue<K> surplusReduceCacheQueue, Integer reduceCacheSize, Long surplusStatusDelay) {
        AssertUtil.assertMethodRequire(surplusReduceCacheQueue, "surplusReduceCacheQueue");
        AssertUtil.assertMethodRequire(surplusStatusDelay, "surplusStatusDelay");
        AssertUtil.assertMethodRequire(reduceCacheSize, "reduceCacheSize");
        this.surplusReduceCacheQueue = surplusReduceCacheQueue;
        this.reduceCacheSize = reduceCacheSize;
        this.surplusStatusDelay = surplusStatusDelay;
    }
}

