/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.surplus.reduce;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.function.PredicateSpread;
import com.mini.framework.util.surplus.reduce.ReduceQueueItem;
import com.mini.framework.util.surplus.reduce.SurplusReduceCacheQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.ListOperations;

public abstract class SurplusReduceCacheQueueRedisTemplateImpl<K>
implements SurplusReduceCacheQueue<K> {
    protected abstract ListOperations<String, ReduceQueueItem> currentListOperation();

    protected abstract String createRedisKey(K var1);

    private ListOperations<String, ReduceQueueItem> safeListOperation() {
        ListOperations<String, ReduceQueueItem> operation = this.currentListOperation();
        AssertUtil.assertNotFatalBug(operation != null, "currentListOperation \u65b9\u6cd5\u8fd4\u56de\u4e86\u7a7a\u6307\u9488", new Object[0]);
        return operation;
    }

    @Override
    public Optional<ReduceQueueItem> popItem(K key) {
        String redisKey = this.createRedisKey(key);
        ReduceQueueItem item = (ReduceQueueItem)this.safeListOperation().rightPop((Object)redisKey);
        return Optional.ofNullable(item).filter(ReduceQueueItem::ifCompleteRecord);
    }

    @Override
    public Optional<List<ReduceQueueItem>> popSatisfiedItems(K key, int size, Predicate<ReduceQueueItem> satisfiedCondition) {
        Optional<ReduceQueueItem> itemOptional;
        ArrayList items = new ArrayList();
        while (items.size() < size && (itemOptional = this.popItem(key)).isPresent()) {
            itemOptional.ifPresent(item -> items.add(item));
        }
        items.stream().allMatch(satisfiedCondition);
        if (items.size() == size && items.stream().allMatch(satisfiedCondition)) {
            return Optional.of(items);
        }
        List<ReduceQueueItem> cancelItems = items.stream().filter(PredicateSpread.of(satisfiedCondition).negate()).collect(Collectors.toList());
        this.batchPushItem(key, cancelItems);
        return Optional.empty();
    }

    @Override
    public void pushItem(K key, ReduceQueueItem item) {
        this.pushItem(this.safeListOperation(), key, item);
    }

    public void pushItem(ListOperations listOperations, K key, ReduceQueueItem item) {
        String redisKey = this.createRedisKey(key);
        listOperations.leftPush((Object)redisKey, (Object)item);
    }

    @Override
    public int queueSize(K key) {
        String redisKey = this.createRedisKey(key);
        long longSize = this.safeListOperation().size((Object)redisKey);
        AssertUtil.assertNotFatalBug(longSize <= Integer.MAX_VALUE, "\u53d1\u73b0redisKey:[%s]\u7684\u96c6\u5408\u503c:[%s]\u5927\u4e8e \u6700\u5927\u7684int", key, longSize);
        AssertUtil.assertNotFatalBug(longSize >= Integer.MIN_VALUE, "\u53d1\u73b0redisKey:[%s]\u7684\u96c6\u5408\u503c:[%s]\u5c0f\u4e8e \u6700\u5c0f\u7684int", key, longSize);
        return (int)longSize;
    }

    @Override
    public void batchPushItem(K key, List<ReduceQueueItem> itemArray) {
        this.redisBatchPushItem(key, itemArray);
    }

    public void simpleBatchPushItem(K key, List<ReduceQueueItem> itemArray) {
        itemArray.forEach(item -> this.pushItem(key, (ReduceQueueItem)item));
    }

    public void redisBatchPushItem(K key, List<ReduceQueueItem> itemArray) {
        String redisKey = this.createRedisKey(key);
        if (!itemArray.isEmpty()) {
            this.safeListOperation().leftPushAll((Object)redisKey, itemArray);
        }
    }
}

