/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.type;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface EnumSupport<E extends EnumSupport<E>> {
    default public String showName() {
        return this.showValue().toString().toString();
    }

    default public E showValue() {
        return (E)((EnumSupport)this.showValues().stream().filter(Predicate.isEqual(this)).findFirst().get());
    }

    default public List<E> showValues() {
        AssertUtil.assertSupport(this.ifSuperEnum(), "\u63a5\u53e3%s\u53ea\u5141\u8bb8\u88abenum\u5b9e\u73b0\u4e0d\u5141\u8bb8\u88ab%s\u5b9e\u73b0", EnumSupport.class.getName(), this.getClass().getName());
        return Stream.of(EnumSupport.findClassAnonymousCompatible(this.getClass()).getEnumConstants()).map(e -> (EnumSupport)e).collect(Collectors.toList());
    }

    public static Class<?> findClassAnonymousCompatible(Class<?> clazz) {
        if (clazz.isAnonymousClass()) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    default public boolean ifSuperEnum() {
        return EnumSupport.findClassAnonymousCompatible(this.getClass()).isEnum();
    }

    default public boolean equalType(E other) {
        return this.equalName(other.showName());
    }

    default public boolean equalName(String otherName) {
        return this.showName().equals(otherName);
    }

    default public boolean equalAnyType(E ... others) {
        return Stream.of(others).anyMatch(this::equalType);
    }
}

