/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.version;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.MiniLogLevel;
import java.io.File;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackageVersionUtil {
    private static final Logger logger = LogManager.getLogger();
    private String dateVersionPattern;
    private String versionFormat;
    private String version;
    private Date createDate;
    private String[] roles = new String[]{"\u4f7f\u7528\u4e00\u4e2a\u524d\u7f00\uff0c\u518d\u6839\u636ejar\u5305\u4e2d\u65f6\u95f4\u751f\u6210\u540e\u7f00\u7ec4\u6210\u4e00\u4e2a\u5b8c\u6574\u7684\u7248\u672c\u8bf4\u660e"};

    public PackageVersionUtil(String versionFormat, String dateVersionPattern) {
        this.dateVersionPattern = dateVersionPattern;
        this.versionFormat = versionFormat;
    }

    public String getDateVersionPattern() {
        return this.dateVersionPattern;
    }

    public String getVersionFormat() {
        return this.versionFormat;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public PackageVersionUtil init() {
        this.createDate();
        this.version();
        return this;
    }

    @Deprecated
    public Date createDate() {
        return this.showCreateDate().orElse(null);
    }

    public Optional<Date> showCreateDate() {
        if (this.createDate == null) {
            this.createDate = this.packageDate().orElse(null);
        }
        return Optional.ofNullable(this.createDate);
    }

    @Deprecated
    public String version() {
        return this.showVersion().orElse(null);
    }

    public Optional<String> showVersion() {
        Optional<Date> createDateOptional;
        if (this.version == null && (createDateOptional = this.showCreateDate()).isPresent()) {
            Date createDate = createDateOptional.get();
            String versionTemp = DateFormatUtils.format((Date)createDate, (String)this.dateVersionPattern);
            this.version = versionTemp = String.format(this.versionFormat, versionTemp);
        }
        return Optional.ofNullable(this.version);
    }

    protected Optional<Date> packageDate() {
        String currentJarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        logger.log(MiniLogLevel.getFrameWorkLog(), "currentJarPath:{}", (Object)currentJarPath);
        String mainJarPath = StringUtils.substringBetween((String)currentJarPath, (String)":", (String)"!");
        logger.log(MiniLogLevel.getFrameWorkLog(), "mainJarPath:{}", (Object)mainJarPath);
        if (mainJarPath == null) {
            return Optional.empty();
        }
        File jarFile = new File(mainJarPath);
        long date = jarFile.lastModified();
        AssertUtil.simpleAssertByStatus(date > 0L, Status.Busy.bug, "\u5f97\u5230\u6587\u4ef6:[%s]\u65f6\u95f4\u4e3a0", jarFile);
        return Optional.of(new Date(date));
    }
}

