package com.mini.framework.util.access;

import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;

public class SimpleAccessBean {

	private String accessKey;

	private String accessToken;

	private Date expireDate;

	private String[] params;

	public SimpleAccessBean(String accessKey, String accessToken, Date expireDate, String[] params) {
		super();
		this.accessKey = accessKey;
		this.accessToken = accessToken;
		this.expireDate = expireDate;
		this.params = params;
	}
	

	public SimpleAccessBean() {
	}
	
	public SimpleAccessBean(String token) {
		super();
		AssertUtil.assertMethodRequire(token, "token");
		AssertUtil.assertNoBadReq(token.length()>30, Status.BadReq.illParam, "accessToken:[%s]长度至少30位以上",token);
		String[] items = RegexUtil.getMatch("([^-]+)-([^-]+)-(\\d+)", token,new int[]{1,2,3} );
		AssertUtil.assertNoBadReq(items!=null, Status.BadReq.illParam, "accessToken:[%s]格式错误",token);
		this.accessKey = items[0];
		this.accessToken = items[1];
		this.expireDate = new Date(Long.parseLong(items[2]));
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	public Date getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(Date expireDate) {
		this.expireDate = expireDate;
	}

	public String[] getParams() {
		return params;
	}

	public void setParams(String[] params) {
		this.params = params;
	}

	public String getAccessKey() {
		return accessKey;
	}

	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}
	
	
	public AccessTokenResp showTokenBean(){
		return new AccessTokenResp(showToken(),params);
	}
	
	public String showToken(){
		AssertUtil.assertSupport(accessKey!=null, "accessKey不能为空");
		AssertUtil.assertSupport(accessToken!=null, "accessToken不能为空");
		AssertUtil.assertSupport(expireDate!=null, "expireDate不能为空");
		return String.format("%s-%s-%s",accessKey , accessToken , expireDate.getTime());
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
