package com.mini.framework.util.bean;

import java.util.ArrayList;
import java.util.List;

import com.mini.framework.util.asserts.AssertUtil;

public class VarColl<T extends Object> {

	private List<T> coll = new ArrayList<>();
	
	public static  <T> VarColl<T> create(){
		return new VarColl<>();
	}

	public VarColl<T> addIfVal(T obj){
		if(obj!=null){
			coll.add(obj);
		}
		return this;
	}
	
	public VarColl<T> add(T obj){
		AssertUtil.assertMethodRequire(obj, "obj");
		return addIfVal(obj);
	}
	
	
	public T[] asArray(T[] array){
		return coll.toArray(array);
	}
	
	public List<T> asList(){
		return new ArrayList<>(coll);
	}
}
