package com.mini.framework.util.bean;

import java.util.HashMap;
import java.util.Objects;
import java.util.Map.Entry;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class VarUtil {
	


	/**
	 * 如果实体存就取他的属性
	 * @param bean
	 * @param supplier
	 * @return
	 */
	public static <T> T ifExistGetField(Object bean ,Supplier<T> supplier) {
		return ifRightGet(bean!=null, supplier);
	}
	
	/**
	 * 如果表达正确就取后面的值
	 * @param explain
	 * @param supplier
	 * @return
	 */
	public static <T> T ifRightGet(boolean explain ,Supplier<T> supplier) {
		if(explain){
			return supplier.get();
		}
		return null;
	}

	public static Object firstNotNull(Object... values) {
		for (Object value : values) {
			if(value!=null){
				return value;
			}
		}
		return null;
	}
	

	public static Integer firstNotNull(Integer... values) {
		Object value = firstNotNull( Stream.of(values).toArray());
		return (Integer) value;
	}
	
	
	public static String firstNotNull(String... values) {
		Object value = firstNotNull( Stream.of(values).toArray());
		return (String) value;
	}
	
	//Potential heap pollution via varargs parameter values
	public static <T> T firstNotNullSimple(T... values) {
		return Stream.of(values).filter(Objects::nonNull).findFirst().orElse(null);
	}
	
	public static <K,V> Entry<K, V> createEntry(K key,V value){
		HashMap<K,V> map = new HashMap<>(1);
		map.put(key, value);
		return map.entrySet().stream().findFirst().get();
	}
	
	
}
