package com.mini.framework.util.cache;

import java.util.function.Supplier;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * Supplier 增强
 * 这里要注意，如果程序依赖线程中的东西不能线此功能
 * @author jayheo
 *
 * @param <T>
 */
public class HoldSupplier<T> implements Supplier<T> {

	protected T hold;

	protected Supplier<T> supplier;

	protected HoldSupplier(Supplier<T> supplier) {
		super();
		AssertUtil.assertSupport(supplier!=null,"supplier不能为空");
		this.supplier = supplier;
	}

	public static <T> HoldSupplier<T> create(Supplier<T> supplier) {
		return new HoldSupplier<>(supplier);
	}

	public T get() {
		if (hold == null) {
			hold = supplier.get();
		}
		return hold;
	}
	
	/**
	 * 把数据清理掉
	 */
	public void clear(){
		hold = null;
	}
}
