package com.mini.framework.util.colony;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author jayheo
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SyncLockMethod {

	/**
	 * 并发锁的key
	 * @return
	 */
	String lockKey();
	
	/**
	 * <pre>
	 * 方法结束后是否立即释放锁
	 * 如果是立即释放的话就可能会在 lockDelay前释放
	 * 比如锁的时间是15分钟，但是方法只执行了5分钟，那么就分钟后释放
	 * 在释放前不可以再使用
	 * </pre>
	 * @return
	 */
	boolean endRelease();
	
	
	/**
	 * <pre>
	 * 每次锁最长的锁住时间
	 * 过了这个时间不管什么情况锁都被释放了
	 * 单位秒钟
	 * </pre>
	 * @return
	 */
	int lockDelay();
	
}
