package com.mini.framework.util.date.bean;

import java.util.Date;
import java.util.Map;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.type.EnumTypeShower;


/**
 * 相对时间的简称方案
 * @author jayheo
 *
 */
public enum RelativeDateAliasScheme implements  EnumTypeShower<RelativeDateAliasScheme> {

	/**
	 * 与当前时间的对比
	 */
	nowScheme1("相对现在时间1","与现在这个时间的相对时间TODO 后面还要加上详细的说明"),;
	
	private static int secondsMilli = 1000;
	
	private static int minuteMilli = secondsMilli*60;
	
	private static int hourMilli = secondsMilli * 60;
	
	private static int dayMilli = hourMilli * 24;

	private static int weekMilli = dayMilli * 7;
	
	private static int monthMilli = dayMilli * 30;
	
	private static long yearMilli = monthMilli * 12;
	
	private int yearAccuracyMin = 2;
	
	private int monthAccuracyMin = 2;

	private int weekAccuracyMin = 2;
	
	private int dayAccuracyMin = 2;
	
	private int hourAccuracyMin = 2;
	
	private int minuteAccuracyMin = 2;
	
	private int secondsAccuracyMin = 2;
	
	private String title;
	
	private String desc;
	
	
	private RelativeDateAliasScheme(String title, String desc) {
		this.title = title;
		this.desc = desc;
	}

	public String countRelativeName(Date selfDate,Date targetDate) {
		AssertUtil.assertMethodRequire(selfDate, "selfDate");
		AssertUtil.assertMethodRequire(targetDate, "targetDate");
		return countRelativeName(selfDate.getTime() - targetDate.getTime());
	}
	
	public String countRelativeName(Long intervalTime) {
		String suffix = intervalTime>0?"后":"前";
		intervalTime = Math.abs(intervalTime);
		if(intervalTime > yearAccuracyMin * yearMilli){
			return yearAccuracyMin/yearMilli + "年" + suffix;
		}else if(intervalTime > monthAccuracyMin* monthMilli){
			return monthAccuracyMin/monthMilli + "月" + suffix;
		}else if(intervalTime > dayAccuracyMin* dayMilli){
			return dayAccuracyMin/dayMilli + "天" + suffix;
		}else if(intervalTime >weekAccuracyMin* weekMilli){
			return weekAccuracyMin/weekMilli + "星期" + suffix;
		}else if(intervalTime > hourAccuracyMin* hourMilli){
			return hourAccuracyMin/hourMilli + "小时" + suffix;
		}else if(intervalTime > minuteAccuracyMin* minuteMilli){
			return minuteAccuracyMin/minuteMilli + "分钟" + suffix;
		}else if(intervalTime > secondsAccuracyMin* secondsMilli){
			return secondsAccuracyMin/secondsMilli + "秒钟" + suffix;
		}else{
			return "刚刚";
		}
	}

	@Override
	public void fillFieldToMap(Map<String, Object> map) {
		map.put("title", title);
		map.put("desc", desc);
	}
}
