package com.mini.framework.util.function;

import com.mini.framework.util.asserts.AssertUtil;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

/**
 * 在要求使用 final 修饰的方法参数时,可以使用此类来包装
 * @author jayheo
 */
public class FinalUsefulBeanOptional<B> {

    private B beanNullable;

    private FinalUsefulBeanOptional(Optional<B> beanOptional) {
        AssertUtil.assertMethodRequire(beanOptional,"beanOptional");
        this.beanNullable = beanOptional.orElse(null);
    }
    private FinalUsefulBeanOptional(B beanNullable) {
        this(Optional.ofNullable(beanNullable));
    }

    public static <B> FinalUsefulBeanOptional<B> empty(){
        return new FinalUsefulBeanOptional<>(Optional.empty());
    }

    public static <B> FinalUsefulBeanOptional<B> ofNullable(B bean){
        return new FinalUsefulBeanOptional<>(bean);
    }
    public static <B> FinalUsefulBeanOptional<B> of(Optional<B> beanOptional){
        return new FinalUsefulBeanOptional<>(beanOptional);
    }
    public static <B> FinalUsefulBeanOptional<B> of(B bean){
        AssertUtil.assertMethodRequire(bean,"bean");
        return new FinalUsefulBeanOptional<>(bean);
    }

    public Optional<B> showOptional() {
        return Optional.ofNullable(beanNullable);
    }

    public FinalUsefulBeanOptional<B> set(Optional<B> beanOptional) {
        beanOptional.ifPresent(this::set);
        return this;
    }
    public FinalUsefulBeanOptional<B> set(B bean) {
        AssertUtil.assertMethodRequire(bean,"bean");
        this.beanNullable = bean;
        return this;
    }



    public void ifNotPresent(Runnable runnable){
        if(beanNullable==null){
            runnable.run();
        }
    }



    public void ifPresent(Consumer<B> consumer){
        if(beanNullable!=null){
            consumer.accept(beanNullable);
        }
    }

    /**
     * @deprecated 请使用 {@link #ifPresent(Consumer)}
     * @param function
     */
    @Deprecated
    public void ifPresent(Function<B,Void> function){
        if(isPresent()){
            function.apply(beanNullable);
        }
    }


    public boolean isNotPresent(){
        return !isPresent();
    }
    public boolean isPresent(){
        return beanNullable != null;
    }



    public <O> FinalUsefulBeanOptional<O> map(Function<B,O> function){
        return FinalUsefulBeanOptional.of(showOptional().map(function));
    }
}
