package com.mini.framework.util.function;

/**
 * 定义一个可以用户final的计数器
 * 在函数计算场景下使用。
 * @author jayheo
 */
public class FinalUsefulCounter {

    /**
     * 当前值
     * */
    private int value;

    /**
     * 创建时初始的值
     * */
    private int initValue;

    private FinalUsefulCounter(int value) {
        this.initValue = value;
        this.value = value;
    }

    /**
     * 创建一个终态计数器
     * 且初始值为 0
     * */
    public static FinalUsefulCounter create(){
        return create(0);
    }

    /**
     * 创建一个终态计数器
     * @param initValue 初始值
     * */
    public static FinalUsefulCounter create(int initValue){
        return new FinalUsefulCounter(initValue);
    }


    /**
     * 加 1
     * */
    public FinalUsefulCounter add(){
        return add(1);
    }

    /**
     * 加 1
     * */
    public FinalUsefulCounter add(boolean explain){
        if(explain){
            return add();
        }else {
            return this;
        }
    }


    /**
     * 加 n
     * @param increment 要加的数
     * */
    public FinalUsefulCounter add(int increment){
        value+=increment;
        return this;
    }

    /**
     * 加 n
     * @param increment 要加的数
     * */
    public FinalUsefulCounter add(boolean explain,int increment){
        if(explain){
            value+=increment;
        }
        return this;
    }


    /**
     * 加 1 并返回当前值
     * */
    public int addShow(){
        return addShow(1);
    }

    /**
     * 加 n 并返回加之后的前值
     * @param increment 要加的数
     * @return 加之后的前值
     * */
    public int addShow(int increment){
        return add(increment).show();
    }

    /**
     * 加 n 并返回加之前的值
     * @param increment
     * @return 加之后的值
     */
    public int showAdd(int increment){
        int value = show();
        add(increment);
        return value;
    }

    /**
     * 加 1 并返回加之前的值
     * @return 加之后的值
     */
    public int showAdd(){
        return showAdd(1);
    }



    /**
     * 减 1
     * */
    public FinalUsefulCounter cut(){
        return cut(1);
    }


    /**
     * 减 n
     * @param increment 要减少的数
     * */
    public FinalUsefulCounter cut(int increment){
        value -= increment;
        return this;
    }


    /**
     * 减 1 并返回当前值
     * */
    public int cutShow(){
        return cutShow(1);
    }


    /**
     * 减 n 并返回当前值
     * @param increment 要减少的数
     * */
    public int cutShow(int increment){
        return cut(increment).show();
    }


    /**
     * 清0
     * */
    public FinalUsefulCounter clear(){
        return set(0);
    }


    /**
     * 把值改成初始的值 initValue
     * */
    public FinalUsefulCounter reset(){
        return set(this.initValue);
    }


    /**
     * 设置值
     * */
    public FinalUsefulCounter set(int value){
        this.value = value;
        return this;
    }


    /**
     * 显示当前的数
     * */
    public int show(){
        return value;
    }


    //---------------------------------


    /**
     * 是不有大于初始值的状态。
     * @return
     */
    public boolean ifHave(){
        return initValue > value;
    }

    /**
     *  没有  大于初始值的状态。
     * @return
     */
    public boolean ifNotHave(){
        return !ifHave();
    }

}
