package com.mini.framework.util.function;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 对Optional的扩展
 * @author jayheo
 *
 */
public interface OptionalSpread {

	/**
	 * 把Optional<T> 变成 
	 * @return
	 */
	static <T> Function<Optional<T>, T> orElseNull() {
		return orElse(null);
	}


	/**
	 * 如果没有就返回空
	 * */
	static <T> T orElseNull(Optional<T> optional) {
		return optional.orElse(null);
	}

	/**
	 * 把Optional<T> 变成 T 
	 * @param t
	 * @return
	 */
	static <T> Function<Optional<T>, T> orElse(T defaultValue) {
		return v -> v.orElse(defaultValue);
	}
	
	/**
	 * 如果第一个值没有时候使用第二个值
	 * @param value
	 * @param valueOnAbsentSupplier
	 * @return
	 */
	static <T> T valueOnAbsent(T value,Supplier<T> valueOnAbsentSupplier){
		AssertUtil.assertMethodRequire(valueOnAbsentSupplier, "valueOnAbsentSupplier");
		if(value==null){
			return value;
		}else{
			return valueOnAbsentSupplier.get();
		}
	}
	
	/**
	 * 如果第一个值没有时候使用第二个值
	 * @param value
	 * @param valueOnAbsent
	 * @return
	 */
	static <T> T valueOnAbsent(T value,T valueOnAbsent){
		return valueOnAbsent(valueOnAbsent, ()->valueOnAbsent);
	}
	
}
	
