package com.mini.framework.util.generic.define;

import com.mini.framework.util.asserts.AssertUtil;

import java.util.Optional;

/**
 * 可选的对象
 * @author jayheo
 */
public class OptionalObject {



    private Object value;

    private static final OptionalObject createEmpty (){
        return new OptionalObject();
    }


    public static OptionalObject ofNullable(Long dateLong){
        return dateLong==null? createEmpty() :of(dateLong);
    }

    public static OptionalObject ofNullable(String dateString){
        return dateString==null? createEmpty() :of(dateString);
    }

    public static OptionalObject ofNullable(Object value){
        return value==null? createEmpty() :of(value);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalObject of(Object value){
        AssertUtil.assertMethodRequire(value,"value");
        OptionalObject optional = new OptionalObject();
        optional.value = value;
        return optional;
    }


    public Optional<Object> out(){
        return Optional.ofNullable(value);
    }

    @Override
    public String toString() {
        return out().toString();
    }


}
